/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.exceptions.NoSuchRelationException;
import de.uni_bremen.st.rcf.exceptions.RelationExistsException;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.EntryManager;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.persistence.AbstractRCFBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.schema.AttributePOJO;
import de.uni_bremen.st.rcf.schema.ParseException;
import de.uni_bremen.st.rcf.schema.Parser;
import de.uni_bremen.st.rcf.schema.RelationPOJO;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractRCF {
    protected AbstractRCFBinding binding;
    private final EntryManager entryManager;
    protected Map<String, Relation<? extends Entry>> relationMap;

    public AbstractRCF(AbstractRCFBinding binding) {
        this.binding = binding;
        this.entryManager = new EntryManager();
        this.relationMap = new HashMap<String, Relation<? extends Entry>>();
        this.createSchema();
    }

    protected EntryManager getEntryManager() {
        return this.entryManager;
    }

    public Relation<Entry> addRelation(String name) {
        if (this.hasRelation(name)) {
            throw new RelationExistsException();
        }
        AbstractRelationBinding rb = this.binding.addRelation(name);
        Relation<Entry> r = new Relation<Entry>(rb, this);
        this.relationMap.put(r.getName(), r);
        return r;
    }

    public boolean hasRelation(String name) {
        return this.relationMap.containsKey(name);
    }

    public Relation<Entry> getRelation(String name) {
        if (this.hasRelation(name)) {
            return this.relationMap.get(name);
        }
        throw new NoSuchRelationException();
    }

    public List<Relation<Entry>> getRelations() {
        ArrayList<Relation<Entry>> ret = new ArrayList<Relation<Entry>>(this.relationMap.size());
        for (Relation<? extends Entry> r : this.relationMap.values()) {
            ret.add(r);
        }
        return ret;
    }

    protected AbstractRCFBinding getBinding() {
        return this.binding;
    }

    private void createSchema() {
        Collection<RelationPOJO> relations;
        InputStream schemaStream = this.getClass().getResourceAsStream("/schema.xml");
        try {
            relations = Parser.parse(schemaStream);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"schema.xml is missing");
        }
        for (RelationPOJO rel : relations) {
            if (this.binding.hasRelation(rel.getName())) continue;
            this.binding.addRelation(rel.getName());
        }
        for (RelationPOJO rel : relations) {
            Relation modelRel = new Relation(this.binding.getRelation(rel.getName()), this, true);
            for (AttributePOJO att : rel.getAttributes()) {
                if (att.getName().equals("id") || modelRel.binding.hasAttribute(att.getName())) continue;
                String[] enumValues = att.getEnumValues().toArray(new String[att.getEnumValues().size()]);
                modelRel.binding.addAttribute(att.getName(), att.getType(), att.isList(), att.isEnum(), att.getReferencedRelation() == null ? null : this.binding.getRelation(att.getReferencedRelation().getName()), enumValues);
            }
        }
    }

    public void save() {
        this.binding.save();
    }

    public void saveAs(File f) {
        this.binding.saveAs(f);
    }

    public void close() {
        this.binding.close();
    }

    public File getFile() {
        return this.binding.getFile();
    }
}

