/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.exceptions.IncompatibleEntryTypesException;
import de.uni_bremen.st.rcf.exceptions.InvalidEnumValueException;
import de.uni_bremen.st.rcf.exceptions.ValueNotSetException;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.EntryManager;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.ValueList;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;
import java.util.List;

public class Entry {
    protected final Relation<? extends Entry> relation;
    protected final AbstractEntryBinding binding;

    protected Entry(Relation<? extends Entry> relation, AbstractEntryBinding aeb) {
        this.relation = relation;
        this.binding = aeb;
    }

    public Relation<? extends Entry> getRelation() {
        return this.relation;
    }

    protected AbstractEntryBinding getBinding() {
        return this.binding;
    }

    public int getId() {
        return this.binding.getId();
    }

    public boolean isSet(Attribute a) {
        return this.binding.isSet(a.getBinding());
    }

    public boolean isSet(String attributeName) {
        return this.isSet(this.relation.getAttribute(attributeName));
    }

    public int getInt(Attribute a) {
        return this.binding.getInt(a.getBinding());
    }

    public int getInt(Attribute a, int defaultValue) {
        try {
            return this.getInt(a);
        }
        catch (ValueNotSetException vnse) {
            return defaultValue;
        }
    }

    public int getInt(String attributeName) {
        return this.getInt(this.relation.getAttribute(attributeName));
    }

    public int getInt(String attributeName, int defaultValue) {
        return this.getInt(this.relation.getAttribute(attributeName), defaultValue);
    }

    public void setInt(Attribute a, int value) {
        this.isValidEnumValue(value, a);
        this.binding.setInt(a.getBinding(), value);
    }

    public void setInt(String attributeName, int value) {
        this.setInt(this.relation.getAttribute(attributeName), value);
    }

    public float getFloat(Attribute a) {
        return this.binding.getFloat(a.getBinding());
    }

    public float getFloat(Attribute a, float defaultValue) {
        try {
            return this.getFloat(a);
        }
        catch (ValueNotSetException vnse) {
            return defaultValue;
        }
    }

    public float getFloat(String attributeName) {
        return this.getFloat(this.relation.getAttribute(attributeName));
    }

    public float getFloat(String attributeName, float defaultValue) {
        return this.getFloat(this.relation.getAttribute(attributeName), defaultValue);
    }

    public void setFloat(Attribute a, float value) {
        this.isValidEnumValue(Float.valueOf(value), a);
        this.binding.setFloat(a.getBinding(), value);
    }

    public void setFloat(String attributeName, float value) {
        this.setFloat(this.relation.getAttribute(attributeName), value);
    }

    public String getString(Attribute a) {
        return this.binding.getString(a.getBinding());
    }

    public String getString(Attribute a, String defaultValue) {
        try {
            return this.getString(a);
        }
        catch (ValueNotSetException vnse) {
            return defaultValue;
        }
    }

    public String getString(String attributeName) {
        return this.getString(this.relation.getAttribute(attributeName));
    }

    public String getString(String attributeName, String defaultValue) {
        return this.getString(this.relation.getAttribute(attributeName), defaultValue);
    }

    public void setString(Attribute a, String value) {
        this.isValidEnumValue(value, a);
        this.binding.setString(a.getBinding(), value);
    }

    public void setString(String attributeName, String value) {
        this.setString(this.relation.getAttribute(attributeName), value);
    }

    public boolean getBool(Attribute a) {
        return this.binding.getBool(a.getBinding());
    }

    public boolean getBool(Attribute a, boolean defaultValue) {
        try {
            return this.getBool(a);
        }
        catch (ValueNotSetException vnse) {
            return defaultValue;
        }
    }

    public boolean getBool(String attributeName) {
        return this.getBool(this.relation.getAttribute(attributeName));
    }

    public boolean getBool(String attributeName, boolean defaultValue) {
        return this.getBool(this.relation.getAttribute(attributeName), defaultValue);
    }

    public void setBool(Attribute a, boolean value) {
        this.binding.setBool(a.getBinding(), value);
    }

    public void setBool(String attributeName, boolean value) {
        this.setBool(this.relation.getAttribute(attributeName), value);
    }

    public Entry getEntry(Attribute a) {
        return this.getEntryManager().getEntry(a.getReferencedRelation(), this.binding.getEntry(a.getBinding()));
    }

    public Entry getEntry(Attribute a, Entry defaultValue) {
        try {
            return this.getEntry(a);
        }
        catch (ValueNotSetException vnse) {
            return defaultValue;
        }
    }

    public Entry getEntry(String attributeName) {
        return this.getEntry(this.relation.getAttribute(attributeName));
    }

    public Entry getEntry(String attributeName, Entry defaultValue) {
        return this.getEntry(this.relation.getAttribute(attributeName), defaultValue);
    }

    public void setEntry(Attribute a, Entry value) {
        if (!a.getReferencedRelation().equals(value.getRelation())) {
            throw new IncompatibleEntryTypesException();
        }
        this.binding.setEntry(a.getBinding(), value.getBinding());
    }

    public void setEntry(String attributeName, Entry value) {
        this.setEntry(this.relation.getAttribute(attributeName), value);
    }

    public List<Integer> getIntList(Attribute a) {
        return this.createValueList(a);
    }

    public List<Integer> getIntList(String attributeName) {
        return this.getIntList(this.relation.getAttribute(attributeName));
    }

    public List<Float> getFloatList(Attribute a) {
        return this.createValueList(a);
    }

    public List<Float> getFloatList(String attributeName) {
        return this.getFloatList(this.relation.getAttribute(attributeName));
    }

    public List<Boolean> getBoolList(Attribute a) {
        return this.createValueList(a);
    }

    public List<Boolean> getBoolList(String attributeName) {
        return this.getBoolList(this.relation.getAttribute(attributeName));
    }

    public List<String> getStringList(Attribute a) {
        return this.createValueList(a);
    }

    public List<String> getStringList(String attributeName) {
        return this.getStringList(this.relation.getAttribute(attributeName));
    }

    public List<Entry> getEntryList(Attribute a) {
        return this.createValueList(a);
    }

    public List<Entry> getEntryList(String attributeName) {
        return this.getEntryList(this.relation.getAttribute(attributeName));
    }

    protected EntryManager getEntryManager() {
        return this.relation.getRCF().getEntryManager();
    }

    protected <T> ValueList<T> createValueList(Attribute a) {
        AbstractValueListBinding vl = this.binding.getList(a.getBinding());
        return new ValueList(this.relation, a, this, vl);
    }

    private void isValidEnumValue(Object value, Attribute a) {
        if (a.isEnum()) {
            String valueString = value.toString();
            List<String> validValues = a.getEnumValues();
            if (!validValues.contains(valueString)) {
                throw new InvalidEnumValueException();
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Entry)) {
            return false;
        }
        AbstractEntryBinding other = ((Entry)obj).getBinding();
        return this.binding.equals(other);
    }

    public int hashCode() {
        return EntryManager.generateEntryHashCode(this);
    }

    public void delete() {
        this.binding.delete();
    }

    @Deprecated
    public void store() {
    }

    public Entry copy(RCF toRCF) {
        Relation<Entry> toRel = toRCF.getRelation(this.relation.getName());
        Entry to = toRel.append();
        block14: for (Attribute fromAtt : this.relation.getAttributes()) {
            Attribute toAtt = null;
            toAtt = toRel.hasAttribute(fromAtt.getName()) ? toRel.getAttribute(fromAtt.getName()) : toRel.addAttribute(fromAtt.getName(), fromAtt.getType(), fromAtt.getReferencedRelation(), fromAtt.isList(), fromAtt.isEnum(), fromAtt.getEnumValues().toArray(new String[0]));
            if (fromAtt.isList()) {
                switch (fromAtt.getType()) {
                    case INTEGER: {
                        List<Integer> toIntList = to.getIntList(toAtt);
                        for (int i : this.getIntList(fromAtt)) {
                            toIntList.add(i);
                        }
                        continue block14;
                    }
                    case FLOAT: {
                        List<Float> toFloatList = to.getFloatList(toAtt);
                        for (float f : this.getFloatList(fromAtt)) {
                            toFloatList.add(Float.valueOf(f));
                        }
                        continue block14;
                    }
                    case STRING: {
                        List<String> toStringList = to.getStringList(toAtt);
                        for (String s : this.getStringList(fromAtt)) {
                            toStringList.add(s);
                        }
                        continue block14;
                    }
                    case BOOLEAN: {
                        List<Boolean> toBoolList = to.getBoolList(toAtt);
                        for (boolean b : this.getBoolList(fromAtt)) {
                            toBoolList.add(b);
                        }
                        continue block14;
                    }
                    case REFERENCE: {
                        continue block14;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            if (!this.isSet(fromAtt)) continue;
            switch (fromAtt.getType()) {
                case INTEGER: {
                    to.setInt(toAtt, this.getInt(fromAtt));
                    continue block14;
                }
                case FLOAT: {
                    to.setFloat(toAtt, this.getFloat(fromAtt));
                    continue block14;
                }
                case STRING: {
                    to.setString(toAtt, this.getString(fromAtt));
                    continue block14;
                }
                case BOOLEAN: {
                    to.setBool(toAtt, this.getBool(fromAtt));
                    continue block14;
                }
                case REFERENCE: {
                    continue block14;
                }
            }
            throw new RuntimeException();
        }
        return to;
    }

    public void unset(String attributeName) {
        this.unset(this.relation.getAttribute(attributeName));
    }

    public void unset(Attribute ab) {
        this.binding.unset(ab.getBinding());
    }
}

