/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.AbstractRCF;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.EntryType;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.SourcePositions;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;

public class Fragments
extends Relation<Fragment> {
    private final Attribute id = this.getAttribute("id");
    private final Attribute clientId = this.getAttribute("clientId");
    private final Attribute start = this.getAttribute("start");
    private final Attribute end = this.getAttribute("end");
    private final Attribute numTokens = this.getAttribute("numTokens");
    private final Attribute predecessors = this.getAttribute("predecessors");
    private final Attribute successors = this.getAttribute("successors");
    private final Attribute cloneClasses = this.getAttribute("cloneClasses");
    private final Attribute clonePairs = this.getAttribute("clonePairs");

    protected Fragments(AbstractRelationBinding binding, AbstractRCF rcf) {
        super(binding, rcf, EntryType.toEntryType("Fragment"), true);
    }

    public Attribute getIdAttribute() {
        return this.id;
    }

    public Attribute getClientIdAttribute() {
        return this.clientId;
    }

    public Attribute getStartAttribute() {
        return this.start;
    }

    public Attribute getEndAttribute() {
        return this.end;
    }

    public Attribute getNumTokensAttribute() {
        return this.numTokens;
    }

    public Attribute getPredecessorsAttribute() {
        return this.predecessors;
    }

    public Attribute getSuccessorsAttribute() {
        return this.successors;
    }

    public Attribute getCloneClassesAttribute() {
        return this.cloneClasses;
    }

    public Attribute getClonePairsAttribute() {
        return this.clonePairs;
    }

    public Fragment addFragment(File file, int beginLine, int endLine, int beginColumn, int endColumn, int numTokens) {
        if (file == null || beginLine < 0 || endLine < 0 || beginLine < 0 || endColumn < 0 || numTokens < 0) {
            throw new IllegalArgumentException();
        }
        Fragment frag = null;
        if (frag == null) {
            frag = (Fragment)this.append();
            SourcePositions spr = this.getRCF().getSourcePositions();
            SourcePosition start = spr.addSourcePosition(file, beginLine, beginColumn);
            SourcePosition end = spr.addSourcePosition(file, endLine, endColumn);
            frag.setStart(start);
            frag.setEnd(end);
            frag.setNumTokens(numTokens);
        }
        return frag;
    }

    public Fragment addFragment(String filePath, Version version, int beginLine, int endLine, int beginColumn, int endColumn, int numTokens) {
        if (filePath == null || version == null) {
            throw new IllegalArgumentException();
        }
        File file = this.getRCF().getFiles().addFile(filePath, version);
        return this.addFragment(file, beginLine, endLine, beginColumn, endColumn, numTokens);
    }

    public Fragment addFragment(File file, int beginOffset, int endOffset, int numTokens) {
        if (file == null || beginOffset < 0 || endOffset < 0 || numTokens < 0) {
            throw new IllegalArgumentException();
        }
        Fragment frag = null;
        if (frag == null) {
            frag = (Fragment)this.append();
            SourcePositions spr = this.getRCF().getSourcePositions();
            SourcePosition start = spr.addSourcePosition(file, beginOffset);
            SourcePosition end = spr.addSourcePosition(file, endOffset);
            frag.setStart(start);
            frag.setEnd(end);
            frag.setNumTokens(numTokens);
        }
        return frag;
    }

    public Fragment addFragment(String filePath, Version version, int beginOffset, int endOffset, int numTokens) {
        if (filePath == null || version == null) {
            throw new IllegalArgumentException();
        }
        File file = this.getRCF().getFiles().addFile(filePath, version);
        return this.addFragment(file, beginOffset, endOffset, numTokens);
    }
}

