/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.exceptions.AttributeExistsException;
import de.uni_bremen.st.rcf.exceptions.NoSuchAttributeException;
import de.uni_bremen.st.rcf.model.AbstractRCF;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.EntryType;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.RelationIterator;
import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Relation<T extends Entry>
implements Iterable<T> {
    private AbstractRCF rcf;
    protected AbstractRelationBinding binding;
    private EntryType entryType;
    private Map<String, Attribute> attributeMap;

    protected Relation(AbstractRelationBinding binding, AbstractRCF rcf, EntryType type, boolean constructionPhase) {
        this.rcf = rcf;
        this.entryType = type;
        this.binding = binding;
        this.attributeMap = new HashMap<String, Attribute>();
        for (AbstractAttributeBinding ab : binding.getAttributes()) {
            this.attributeMap.put(ab.getName(), new Attribute(ab, this, constructionPhase));
        }
    }

    protected Relation(AbstractRelationBinding binding, AbstractRCF rcf, EntryType type) {
        this(binding, rcf, type, false);
    }

    protected Relation(AbstractRelationBinding binding, AbstractRCF rcf) {
        this(binding, rcf, EntryType.ENTRY);
    }

    protected Relation(AbstractRelationBinding binding, AbstractRCF rcf, boolean constructionPhase) {
        this(binding, rcf, EntryType.ENTRY, constructionPhase);
    }

    public String getName() {
        return this.binding.getName();
    }

    public RCF getRCF() {
        return (RCF)this.rcf;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public List<Attribute> getAttributes() {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        for (Attribute a : this.attributeMap.values()) {
            ret.add(a);
        }
        return ret;
    }

    public Attribute addScalarAttribute(String name, AttributeType type) {
        return this.addAttribute(name, type, null, false, false, new String[0]);
    }

    public Attribute addEnumAttribute(String name, AttributeType type, String ... enumValues) {
        return this.addAttribute(name, type, null, false, true, enumValues);
    }

    public Attribute addReferenceAttribute(String name, Relation<? extends Entry> referencedRelation) {
        return this.addAttribute(name, AttributeType.REFERENCE, referencedRelation, false, false, new String[0]);
    }

    public Attribute addListAttribute(String name, AttributeType type) {
        return this.addAttribute(name, type, null, true, false, new String[0]);
    }

    public Attribute addReferenceListAttribute(String name, AttributeType type, Relation<? extends Entry> referencedRelation) {
        return this.addAttribute(name, type, referencedRelation, true, false, new String[0]);
    }

    public Attribute addAttribute(String name, AttributeType type, Relation<? extends Entry> referencedRelation, boolean isList, boolean isEnum, String ... enumValues) {
        if (!this.validateAttributeName(name)) {
            throw new IllegalArgumentException("Illegal Attribute name: " + name);
        }
        if (isEnum && type == AttributeType.REFERENCE) {
            throw new IllegalArgumentException("Cannot create enum attribute of type reference!");
        }
        if (isEnum && type == AttributeType.BOOLEAN) {
            throw new IllegalArgumentException("Cannot create enum attribute of type boolean!");
        }
        if (isEnum && !this.validateEnumValues(enumValues)) {
            throw new IllegalArgumentException("Illegal EnumValues.");
        }
        if (this.hasAttribute(name)) {
            throw new AttributeExistsException();
        }
        AbstractAttributeBinding aab = this.binding.addAttribute(name, type, isList, isEnum, referencedRelation == null ? null : referencedRelation.getBinding(), enumValues);
        Attribute ret = new Attribute(aab, this);
        this.attributeMap.put(name, ret);
        return ret;
    }

    private boolean validateEnumValues(String ... enumValues) {
        if (enumValues.length == 0) {
            return false;
        }
        for (String s : enumValues) {
            if (!s.contains(",")) continue;
            return false;
        }
        return true;
    }

    private boolean validateAttributeName(String name) {
        return name.length() != 0 && !name.equals("id") && !name.contains(" ") && !name.contains("\t") && !name.contains("\n");
    }

    public Attribute getAttribute(String name) {
        if (this.hasAttribute(name)) {
            return this.attributeMap.get(name);
        }
        throw new NoSuchAttributeException();
    }

    protected AbstractRelationBinding getBinding() {
        return this.binding;
    }

    public boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    @Override
    public RelationIterator<T> iterator() {
        return new RelationIterator(this.binding.iterator(), this);
    }

    public T getFirstEntry() {
        return (T)((RelationIterator)this.iterator()).next();
    }

    public T append() {
        AbstractEntryBinding aeb = this.binding.createEntry();
        return (T)this.rcf.getEntryManager().getEntry(this, aeb);
    }

    public int size() {
        return this.binding.size();
    }

    public boolean equals(Object other) {
        return this.getRCF() == ((Relation)other).getRCF() && this.getName().equals(((Relation)other).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public T getEntry(int id) {
        return (T)this.getRCF().getEntryManager().getEntry(this, this.binding.getEntry(id));
    }

    protected void initCache() {
    }

    protected void removeFromCache(AbstractEntryBinding aeb) {
    }

    protected void updateCache(AbstractEntryBinding aeb) {
    }
}

