/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.EntryManager;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.ValueListIterator;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ValueList<T>
implements List<T> {
    private final Relation<? extends Entry> relation;
    private final Attribute attribute;
    private final Entry entry;
    private final AbstractValueListBinding<T> binding;
    private final EntryManager em;

    protected ValueList(Relation<? extends Entry> relation, Attribute attribute, Entry entry, AbstractValueListBinding<T> binding) {
        this.relation = relation;
        this.attribute = attribute;
        this.entry = entry;
        this.binding = binding;
        this.em = relation.getRCF().getEntryManager();
    }

    public Relation<? extends Entry> getRelation() {
        return this.relation;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Entry getEntry() {
        return this.entry;
    }

    private boolean isReferencial() {
        return this.attribute.getType() == AttributeType.REFERENCE;
    }

    private List<AbstractEntryBinding> toEntryBindingList(Collection<?> c) {
        ArrayList<AbstractEntryBinding> l = new ArrayList<AbstractEntryBinding>();
        for (Object o : c) {
            l.add(((Entry)o).getBinding());
        }
        return l;
    }

    private AbstractEntryBinding toEntryBinding(Object o) {
        return ((Entry)o).getBinding();
    }

    @Override
    public boolean add(T e) {
        if (this.isReferencial()) {
            return this.addReference((Entry)e);
        }
        return this.binding.add(e);
    }

    protected boolean addReference(Entry e) {
        return this.binding.addReference(e.getBinding());
    }

    @Override
    public void add(int index, T element) {
        if (this.isReferencial()) {
            this.binding.addReference(index, ((Entry)element).getBinding());
        } else {
            this.binding.add(index, element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this.isReferencial()) {
            return this.binding.addAllReference(this.toEntryBindingList(c));
        }
        return this.binding.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (this.isReferencial()) {
            return this.binding.addAllReference(index, this.toEntryBindingList(c));
        }
        return this.binding.addAll(index, c);
    }

    @Override
    public void clear() {
        this.binding.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (this.isReferencial()) {
            return this.binding.containsReference(this.toEntryBinding(o));
        }
        return this.binding.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.isReferencial()) {
            return this.binding.containsAllReference(this.toEntryBindingList(c));
        }
        return this.binding.containsAll(c);
    }

    @Override
    public T get(int index) {
        if (this.isReferencial()) {
            return (T)this.em.getEntry(this.attribute.getReferencedRelation(), this.binding.getReference(index));
        }
        return (T)this.binding.get(index);
    }

    @Override
    public int indexOf(Object o) {
        if (this.isReferencial()) {
            return this.binding.indexOfReference(this.toEntryBinding(o));
        }
        return this.binding.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.binding.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new ValueListIterator(this, 0);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.isReferencial()) {
            return this.binding.lastIndexOfReference(this.toEntryBinding(o));
        }
        return this.binding.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ValueListIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ValueListIterator(this, index);
    }

    @Override
    public boolean remove(Object o) {
        if (this.isReferencial()) {
            return this.binding.removeReference(this.toEntryBinding(o));
        }
        return this.binding.remove(o);
    }

    @Override
    public T remove(int index) {
        if (this.isReferencial()) {
            this.binding.removeReferece(index);
            return null;
        }
        return (T)this.binding.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.isReferencial()) {
            return this.binding.removeAllReference(this.toEntryBindingList(c));
        }
        return this.binding.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.isReferencial()) {
            return this.binding.retainAllReference(this.toEntryBindingList(c));
        }
        return this.binding.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        if (this.isReferencial()) {
            return (T)this.em.getEntry(this.attribute.getReferencedRelation(), this.binding.setReference(index, this.toEntryBinding(element)));
        }
        return this.binding.set(index, element);
    }

    @Override
    public int size() {
        return this.binding.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (this.isReferencial()) {
            List<AbstractEntryBinding> l = this.binding.subListReference(fromIndex, toIndex);
            ArrayList<Entry> ret = new ArrayList<Entry>();
            for (AbstractEntryBinding aeb : l) {
                ret.add(this.em.getEntry(this.attribute.getReferencedRelation(), aeb));
            }
            return ret;
        }
        return this.binding.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        if (this.isReferencial()) {
            List<AbstractEntryBinding> l = this.binding.subListReference(0, this.size() - 1);
            ArrayList<Entry> ret = new ArrayList<Entry>();
            for (AbstractEntryBinding aeb : l) {
                ret.add(this.em.getEntry(this.attribute.getReferencedRelation(), aeb));
            }
            return ret.toArray();
        }
        return this.binding.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        if (this.isReferencial()) {
            List<AbstractEntryBinding> l = this.binding.subListReference(0, this.size() - 1);
            ArrayList<Entry> ret = new ArrayList<Entry>();
            for (AbstractEntryBinding aeb : l) {
                ret.add(this.em.getEntry(this.attribute.getReferencedRelation(), aeb));
            }
            return ret.toArray(a);
        }
        return this.binding.toArray(a);
    }
}

