/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.model;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.ClonePair;
import de.uni_bremen.st.rcf.model.Directory;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.Versions;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.util.PathUtils;
import java.io.IOException;
import java.util.List;

public final class Version
extends Entry {
    private final Versions concreteRelation;

    protected Version(Versions relation, AbstractEntryBinding aeb) {
        super(relation, aeb);
        this.concreteRelation = relation;
    }

    public Relation<Version> getRelation() {
        return super.getRelation();
    }

    public int getClientId() {
        int i = this.getInt(this.concreteRelation.getClientIdAttribute());
        return i;
    }

    public int getClientId(int defaultValue) {
        int i = this.getInt(this.concreteRelation.getClientIdAttribute(), defaultValue);
        return i;
    }

    public void setClientId(int i) {
        this.setInt(this.concreteRelation.getClientIdAttribute(), i);
    }

    public boolean isClientIdSet() {
        return super.isSet(this.concreteRelation.getClientIdAttribute());
    }

    public String getBasepath() {
        String s = this.getString(this.concreteRelation.getBasepathAttribute());
        s = this.getBasepathExtension(s);
        return s;
    }

    public String getBasepath(String defaultValue) {
        String s = this.getString(this.concreteRelation.getBasepathAttribute(), defaultValue);
        s = this.getBasepathExtension(s);
        return s;
    }

    public void setBasepath(String s) {
        s = this.setBasepathExtension(s);
        this.setString(this.concreteRelation.getBasepathAttribute(), s);
    }

    public boolean isBasepathSet() {
        return super.isSet(this.concreteRelation.getBasepathAttribute());
    }

    private String setBasepathExtension(String s) {
        s = PathUtils.normalizePath(s);
        s = PathUtils.normalizeBasepath(s);
        return s;
    }

    private String getBasepathExtension(String s) {
        return PathUtils.translatePath(s);
    }

    public List<ClonePair> getClonePairs() {
        return this.createValueList(this.concreteRelation.getClonePairsAttribute());
    }

    public List<CloneClass> getCloneClasses() {
        return this.createValueList(this.concreteRelation.getCloneClassesAttribute());
    }

    public List<File> getFiles() {
        return this.createValueList(this.concreteRelation.getFilesAttribute());
    }

    public List<Directory> getDirectories() {
        return this.createValueList(this.concreteRelation.getDirectoriesAttribute());
    }

    public String getCanonicalBasepath() {
        String regex;
        String bp = this.getBasepath();
        if (bp.matches(regex = "(^(/|[A-Z]:/|[A-Z]:\\\\)).*")) {
            return bp;
        }
        java.io.File f = null;
        try {
            f = this.relation.getRCF().getFile().getCanonicalFile();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (bp.equals(".")) {
            return f.getParentFile().getAbsolutePath();
        }
        return f.getParentFile().getAbsolutePath() + java.io.File.separator + this.getBasepath();
    }
}

