/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence;

import de.uni_bremen.st.rcf.persistence.AbstractPersistenceManager;
import de.uni_bremen.st.rcf.persistence.FormatInfo;
import de.uni_bremen.st.rcf.persistence.bauhaus.BauhausPersistenceManager;
import de.uni_bremen.st.reuse.BauhausStreamReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class PersistenceManagerFactory {
    private PersistenceManagerFactory() {
    }

    public static AbstractPersistenceManager getPersistenceManager(File rcfFile) throws FileNotFoundException {
        FormatInfo fi = PersistenceManagerFactory.getFormatInfo(rcfFile);
        switch (fi.getFormat()) {
            case BINARY: {
                return new BauhausPersistenceManager();
            }
        }
        return null;
    }

    public static FormatInfo getFormatInfo(File rcfFile) throws FileNotFoundException {
        if (!rcfFile.exists()) {
            throw new FileNotFoundException();
        }
        FormatInfo fi = new FormatInfo();
        BauhausStreamReader reader = new BauhausStreamReader();
        try {
            reader.open(rcfFile.getAbsolutePath());
            String prologue = reader.readString();
            if (prologue.equals("RCF 2.0")) {
                fi.setFormat(FormatInfo.Format.BINARY);
                fi.setMajorVersion(2);
                fi.setMinorVersion(0);
                return fi;
            }
            if (prologue.equals("RCF 2.1")) {
                fi.setFormat(FormatInfo.Format.BINARY);
                fi.setMajorVersion(2);
                fi.setMinorVersion(1);
                return fi;
            }
            fi.setFormat(FormatInfo.Format.DB40);
            fi.setMajorVersion(1);
            fi.setMinorVersion(0);
            return fi;
        }
        catch (IOException e) {
            fi.setFormat(FormatInfo.Format.DB40);
            return fi;
        }
    }
}

