/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.bauhaus;

import de.uni_bremen.st.rcf.exceptions.AttributeExistsException;
import de.uni_bremen.st.rcf.exceptions.NoSuchAttributeException;
import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRCFBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationBinding;
import de.uni_bremen.st.rcf.persistence.AbstractRelationIteratorBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.EntryBinding;
import de.uni_bremen.st.rcf.persistence.bauhaus.RelationIteratorBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationBinding
extends AbstractRelationBinding {
    protected Map<String, AttributeBinding> attributes = new HashMap<String, AttributeBinding>();
    protected AttributeBinding idAttribute;
    protected int lastDeletion = 0;
    private int nextId = 1;

    public RelationBinding(AbstractRCFBinding rcf, String name) {
        super(rcf, name);
        this.addAttribute("id", AttributeType.INTEGER, false, false, null, new String[0]);
    }

    @Override
    public AbstractEntryBinding getEntry(int id) {
        return new EntryBinding(this, id);
    }

    @Override
    public AbstractEntryBinding createEntry() {
        int newOffset = this.idAttribute.intData.size();
        block6: for (AttributeBinding ab : this.attributes.values()) {
            if (ab.isList()) {
                ab.listStarts.add(-1);
                ab.listEnds.add(-1);
                continue;
            }
            switch (ab.getType()) {
                case INTEGER: 
                case REFERENCE: {
                    ab.intData.add(Integer.MIN_VALUE);
                    continue block6;
                }
                case FLOAT: {
                    ab.floatData.add(-3.40282E38f);
                    continue block6;
                }
                case STRING: {
                    ab.stringData.add("__unset_str__");
                    continue block6;
                }
                case BOOLEAN: {
                    ab.boolData.add((byte)-1);
                    continue block6;
                }
            }
            throw new AssertionError();
        }
        this.idAttribute.intData.set(newOffset, this.nextId);
        int id = this.nextId++;
        return new EntryBinding(this, id);
    }

    @Override
    public void deleteEntry(int id) {
        int offset = this.idAttribute.intData.indexOf(id);
        block6: for (AttributeBinding ab : this.attributes.values()) {
            if (!ab.isList()) {
                switch (ab.getType()) {
                    case INTEGER: 
                    case REFERENCE: {
                        ab.intData.remove(offset);
                        continue block6;
                    }
                    case FLOAT: {
                        ab.floatData.remove(offset);
                        continue block6;
                    }
                    case STRING: {
                        ab.stringData.remove(offset);
                        continue block6;
                    }
                    case BOOLEAN: {
                        ab.boolData.remove(offset);
                        continue block6;
                    }
                }
                throw new AssertionError();
            }
            ab.listStarts.remove(offset);
            ab.listEnds.remove(offset);
        }
        ++this.lastDeletion;
    }

    @Override
    public AbstractAttributeBinding getAttribute(String name) {
        if (!this.hasAttribute(name)) {
            throw new NoSuchAttributeException();
        }
        return this.attributes.get(name);
    }

    @Override
    public List<AbstractAttributeBinding> getAttributes() {
        return new ArrayList<AbstractAttributeBinding>(this.attributes.values());
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public AbstractAttributeBinding addAttribute(String name, AttributeType type, boolean isList, boolean isEnum, AbstractRelationBinding referencedRelation, String ... enumValues) {
        if (this.hasAttribute(name)) {
            throw new AttributeExistsException();
        }
        AttributeBinding att = new AttributeBinding(name, type, isList, isEnum, enumValues, this, (RelationBinding)referencedRelation);
        this.attributes.put(name, att);
        if (name.equals("id")) {
            this.idAttribute = att;
        }
        return att;
    }

    @Override
    public int size() {
        return ((AttributeBinding)this.getAttribute((String)"id")).intData.size();
    }

    @Override
    public AbstractRelationIteratorBinding iterator() {
        return new RelationIteratorBinding(this);
    }

    protected AttributeBinding getIdAttribute() {
        return this.idAttribute;
    }

    protected void refresh() {
        if (this.size() > 0) {
            this.nextId = this.idAttribute.intData.get(this.idAttribute.intData.size() - 1);
        }
    }
}

