/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.schema;

import de.uni_bremen.st.rcf.schema.ParseException;
import de.uni_bremen.st.rcf.schema.RelationPOJO;
import de.uni_bremen.st.rcf.schema.SAXHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser {
    public static Collection<RelationPOJO> parse(InputStream schemaStream) throws ParseException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            SAXHandler handler = new SAXHandler();
            saxParser.parse(schemaStream, (DefaultHandler)handler);
            return handler.getRelations();
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
        catch (SAXException se) {
            throw new ParseException(se);
        }
        catch (ParserConfigurationException pce) {
            throw new ParseException(pce);
        }
    }

    public static Collection<RelationPOJO> parse(String schema) throws ParseException {
        InputSource is = new InputSource(new StringReader(schema));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            SAXHandler handler = new SAXHandler();
            saxParser.parse(is, (DefaultHandler)handler);
            return handler.getRelations();
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
        catch (SAXException se) {
            throw new ParseException(se);
        }
        catch (ParserConfigurationException pce) {
            throw new ParseException(pce);
        }
    }
}

