/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.SourcePosition;
import java.io.PrintStream;
import java.util.List;

public class CCFOutput {
    private static PrintStream out = System.out;

    static void printCCF(RCF rcf, List<Integer> excludeTypes) {
        CCFOutput.printCCF(rcf, excludeTypes, false);
    }

    static void printCCF(RCF rcf, List<Integer> excludeTypes, boolean printColumns) {
        out.format("CCF-V1-L%s\n", printColumns ? "C" : "");
        for (CloneClass cc : rcf.getCloneClasses()) {
            if (excludeTypes.contains(cc.getType())) continue;
            out.format("@\t%d\n", cc.getId());
            for (Fragment f : cc.getFragments()) {
                SourcePosition start = f.getStart();
                SourcePosition end = f.getEnd();
                if (printColumns) {
                    out.format("%s\t%d\t%d\t%d\t%d\n", start.getFile().getAbsolutePath(), start.getLine(), start.getColumn(0), end.getLine(), end.getColumn(0));
                }
                out.format("%s\t%d\t%d\n", start.getFile().getAbsolutePath(), start.getLine(), end.getLine());
            }
        }
    }
}

