/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

public final class PathUtils {
    private static final Plattform PLATTFORM = System.getProperty("os.name").startsWith("Windows") ? Plattform.win : Plattform.unix;

    private PathUtils() {
    }

    public static String translatePath(String path) {
        if (PLATTFORM == Plattform.win) {
            return path.replaceAll("/", "\\\\");
        }
        return path;
    }

    public static String normalizePath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static String normalizeBasepath(String basepath) {
        if (basepath == null) {
            throw new IllegalArgumentException("Basepath was null.");
        }
        if (basepath.length() == 0) {
            throw new IllegalArgumentException("Basepath may not be empty.");
        }
        String bp = basepath.trim();
        if (bp.endsWith("/")) {
            bp = bp.substring(0, bp.length() - 1);
        }
        return bp;
    }

    public static String stripBasepath(String basepath, String toStrip) {
        if (basepath.length() == 0) {
            return toStrip;
        }
        String bp = PathUtils.normalizeBasepath(basepath);
        String ts = PathUtils.normalizePath(toStrip);
        if (ts.startsWith(bp) && (ts = ts.substring(bp.length())).startsWith("/")) {
            ts = ts.substring(1);
        }
        return ts;
    }

    private static enum Plattform {
        win,
        unix;

    }
}

