/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.exceptions.NoSuchAttributeException;
import de.uni_bremen.st.rcf.exceptions.NoSuchRelationException;
import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Transformation {
    public static void transform(RCF from, RCF to) {
        Attribute toA;
        Entry toE;
        HashMap relationAttributes;
        HashMap relationEntries;
        Relation<Entry> toR;
        if (from == null || to == null) {
            throw new IllegalArgumentException("from and to must not be null.");
        }
        List<Relation<Entry>> toRels = to.getRelations();
        for (Relation<Entry> r : toRels) {
            if (r.size() == 0) continue;
            throw new IllegalArgumentException("All relations of to must be empty.");
        }
        System.out.println("Copying schema...");
        List<Relation<Entry>> fromRels = from.getRelations();
        for (Relation<Entry> fromR : fromRels) {
            Relation<Entry> toR2 = null;
            try {
                toR2 = to.getRelation(fromR.getName());
            }
            catch (NoSuchRelationException nsre) {
                toR2 = to.addRelation(fromR.getName());
            }
            List<Attribute> fromAttributes = fromR.getAttributes();
            for (Attribute fromA : fromAttributes) {
                String name = fromA.getName();
                Attribute toA2 = null;
                try {
                    toA2 = toR2.getAttribute(name);
                    if (toA2.getType().equals((Object)fromA.getType())) continue;
                    throw new IllegalArgumentException("Schema of from cannot converted to schema of to:\nAttributes with the same names in the same relation have to have the same type");
                }
                catch (NoSuchAttributeException nsae) {
                    toA2 = toR2.addAttribute(name, fromA.getType(), toR2, fromA.isList(), fromA.isEnum(), fromA.getEnumValues().toArray(new String[0]));
                }
            }
        }
        System.out.println("\t... done");
        System.out.println("Copying entries...");
        HashMap<String, HashMap<Entry, Entry>> entries = new HashMap<String, HashMap<Entry, Entry>>();
        HashMap<String, HashMap> attributes = new HashMap<String, HashMap>();
        List<Relation<Entry>> fromRelations = from.getRelations();
        boolean[] relHasRef = new boolean[fromRelations.size()];
        int i = 0;
        for (Relation<Entry> fromR : fromRelations) {
            toR = to.getRelation(fromR.getName());
            relationEntries = new HashMap();
            entries.put(toR.getName(), relationEntries);
            relationAttributes = new HashMap();
            for (Attribute toA3 : toR.getAttributes()) {
                relationAttributes.put(fromR.getAttribute(toA3.getName()), toA3);
            }
            attributes.put(toR.getName(), relationAttributes);
            for (Entry fromE : fromR) {
                toE = toR.append();
                for (Map.Entry aa : relationAttributes.entrySet()) {
                    toA = (Attribute)aa.getValue();
                    boolean isRef = toA.getType().equals((Object)AttributeType.REFERENCE);
                    if (!isRef) {
                        Attribute fromA = (Attribute)aa.getKey();
                        if (!fromE.isSet(fromA)) continue;
                        Transformation.copyValue(toA, fromA, fromE, toE);
                        continue;
                    }
                    relHasRef[i] = true;
                }
                relationEntries.put(fromE, toE);
            }
            ++i;
        }
        System.out.println("\t... done");
        System.out.println("Rebuilding references...");
        i = 0;
        for (Relation<Entry> fromR : fromRelations) {
            if (relHasRef[i]) {
                toR = to.getRelation(fromR.getName());
                relationEntries = (HashMap)entries.get(toR.getName());
                relationAttributes = (HashMap)attributes.get(toR.getName());
                for (Entry fromE : fromR) {
                    toE = (Entry)relationEntries.get(fromE);
                    for (Map.Entry aa : relationAttributes.entrySet()) {
                        Attribute fromA;
                        toA = (Attribute)aa.getValue();
                        if (!toA.getType().equals((Object)AttributeType.REFERENCE) || !fromE.isSet(fromA = (Attribute)aa.getKey())) continue;
                        if (toA.isList()) {
                            Transformation.copyReferenceList(entries, toA, fromA, fromE, toE);
                            continue;
                        }
                        toE.setEntry(toA, Transformation.copyReference(entries, toA, fromA, fromE.getEntry(fromA)));
                    }
                }
            }
            ++i;
        }
        System.out.println("\t... done");
    }

    private static void copyValue(Attribute toA, Attribute fromA, Entry fromE, Entry toE) {
        switch (toA.getType()) {
            case INTEGER: {
                if (toA.isList()) {
                    Transformation.copyList(fromE.getIntList(fromA), toE.getIntList(toA));
                    break;
                }
                toE.setInt(toA, fromE.getInt(fromA));
                break;
            }
            case FLOAT: {
                if (toA.isList()) {
                    Transformation.copyList(fromE.getFloatList(fromA), toE.getFloatList(toA));
                    break;
                }
                toE.setFloat(toA, fromE.getFloat(fromA));
                break;
            }
            case STRING: {
                if (toA.isList()) {
                    Transformation.copyList(fromE.getStringList(fromA), toE.getStringList(toA));
                    break;
                }
                toE.setString(toA, fromE.getString(fromA));
                break;
            }
            case BOOLEAN: {
                if (toA.isList()) {
                    Transformation.copyList(fromE.getBoolList(fromA), toE.getBoolList(toA));
                    break;
                }
                toE.setBool(toA, fromE.getBool(fromA));
                break;
            }
        }
    }

    private static void copyList(List from, List to) {
        for (Object o : from) {
            to.add(o);
        }
    }

    private static void copyReferenceList(HashMap<String, HashMap<Entry, Entry>> entries, Attribute toA, Attribute fromA, Entry fromE, Entry toE) {
        List<Entry> toRefList = toE.getEntryList(toA);
        for (Entry fromRef : fromE.getEntryList(fromA)) {
            toRefList.add(Transformation.copyReference(entries, toA, fromA, fromRef));
        }
    }

    private static Entry copyReference(HashMap<String, HashMap<Entry, Entry>> entries, Attribute toA, Attribute fromA, Entry fromRef) {
        HashMap<Entry, Entry> relationEntries = entries.get(fromRef.getRelation().getName());
        return relationEntries.get(fromRef);
    }
}

