/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util.offsethandling;

import de.uni_bremen.st.rcf.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class OffsetCounter {
    private List<Integer> linesLengths = new ArrayList<Integer>();
    private int readerSize = 0;

    public OffsetCounter(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String line = "";
        int character = -1;
        while ((character = bufferedReader.read()) > 0) {
            line = line + (char)character;
            if (character == 10) {
                this.addLine(line);
                line = "";
                continue;
            }
            if (character != 13) continue;
            bufferedReader.mark(1);
            character = bufferedReader.read();
            if (character == 10) {
                line = line + (char)character;
            } else {
                bufferedReader.reset();
            }
            this.addLine(line);
            line = "";
        }
        this.addLine(line);
        bufferedReader.close();
    }

    public Pair<Integer, Integer> countLineAndColumn(int offset) {
        if (offset > this.readerSize) {
            int lineLengthsSize = this.linesLengths.size();
            return new Pair<Integer, Integer>(lineLengthsSize - 1, this.linesLengths.get(lineLengthsSize - 1));
        }
        if (offset < 0) {
            return new Pair<Integer, Integer>(0, 0);
        }
        int line = 0;
        int lineLength = this.linesLengths.get(line);
        while (offset > lineLength) {
            offset -= lineLength;
            lineLength = this.linesLengths.get(++line);
        }
        return new Pair<Integer, Integer>(line + 1, offset + 1);
    }

    private void addLine(String line) {
        this.linesLengths.add(line.length());
        this.readerSize += line.length();
    }
}

