/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.algo;

import edu.tum.cs.commons.algo.UnionFindWithSize;
import edu.tum.cs.commons.assertion.CCSMAssert;
import edu.tum.cs.commons.assertion.CCSMPre;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUnionFind<T> {
    private final UnionFindWithSize unionFind = new UnionFindWithSize();
    private final Map<T, Integer> lookup;
    private final List<T> elements = new ArrayList<T>();

    public ObjectUnionFind() {
        this(new HashMap());
    }

    public ObjectUnionFind(HashMap<T, Integer> lookup) {
        this.lookup = lookup;
        lookup.clear();
    }

    public T find(T element) {
        Integer index = this.lookup.get(element);
        if (index == null) {
            return element;
        }
        return this.elements.get(this.unionFind.find(index));
    }

    public void union(T element1, T element2) {
        if (!this.containsElement(element1)) {
            this.addElement(element1);
        }
        if (!this.containsElement(element2)) {
            this.addElement(element2);
        }
        this.unionFind.union(this.lookup.get(element1), this.lookup.get(element2));
    }

    public void addElement(T element) {
        CCSMPre.isFalse(this.containsElement(element), "May not add element twice.");
        int index = this.unionFind.addElement();
        CCSMAssert.isTrue(index == this.elements.size(), "Elements not managed consistently!");
        this.elements.add(element);
        this.lookup.put(element, index);
    }

    public boolean containsElement(T element) {
        return this.lookup.containsKey(element);
    }

    public int getClusterSize(T element) {
        Integer index = this.lookup.get(element);
        if (index == null) {
            return 1;
        }
        return this.unionFind.getClusterSize(index);
    }
}

