/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.algo;

import edu.tum.cs.commons.collections.ManagedIntArray;

public class UnionFind
extends ManagedIntArray {
    public int find(int element) {
        if (element >= this.size) {
            throw new IllegalArgumentException("Unknown element!");
        }
        while (element != this.array[element]) {
            int next = this.array[element];
            this.array[element] = this.array[next];
            element = next;
        }
        return element;
    }

    public void union(int element1, int element2) {
        if (element1 >= this.size || element2 >= this.size) {
            throw new IllegalArgumentException("Unknown elements!");
        }
        if ((element1 = this.find(element1)) != (element2 = this.find(element2))) {
            if (Math.random() > 0.5) {
                this.connectToRepresentative(element1, element2);
            } else {
                this.connectToRepresentative(element2, element1);
            }
        }
    }

    protected void connectToRepresentative(int element, int representative) {
        this.array[element] = representative;
    }

    public int addElement() {
        int index = this.size;
        this.addArrayElement();
        this.array[index] = index;
        return index;
    }
}

