/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.collections;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.collections.UnmodifiableSet;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterSet<E> {
    protected final Map<E, Integer> map = new LinkedHashMap<E, Integer>();
    protected int total = 0;

    public void inc(E key, int increment) {
        Integer value = this.map.get(key);
        int newValue = value == null ? increment : value + increment;
        this.map.put(key, newValue);
        this.total += increment;
    }

    public void inc(E key) {
        this.inc(key, 1);
    }

    public boolean contains(E key) {
        return this.map.containsKey(key);
    }

    public int getValue(E key) {
        Integer value = this.map.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public UnmodifiableSet<E> getKeys() {
        return CollectionUtils.asUnmodifiable(this.map.keySet());
    }

    public int getTotal() {
        return this.total;
    }
}

