/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.collections;

import edu.tum.cs.commons.assertion.CCSMPre;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairList<S, T> {
    private int size = 0;
    private Object[] firstElements;
    private Object[] secondElements;

    public PairList() {
        this(16);
    }

    public PairList(int initialCapacity) {
        this.firstElements = new Object[initialCapacity];
        this.secondElements = new Object[initialCapacity];
    }

    public PairList(PairList<S, T> other) {
        this(other.size);
        this.addAll(other);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void add(S first, T second) {
        this.ensureSpace(this.size + 1);
        this.firstElements[this.size] = first;
        this.secondElements[this.size] = second;
        ++this.size;
    }

    public void addAll(PairList<S, T> other) {
        int otherSize = other.size;
        this.ensureSpace(this.size + otherSize);
        for (int i = 0; i < otherSize; ++i) {
            this.firstElements[this.size] = other.firstElements[i];
            this.secondElements[this.size] = other.secondElements[i];
            ++this.size;
        }
    }

    protected void ensureSpace(int space) {
        int newSize;
        if (space <= this.firstElements.length) {
            return;
        }
        Object[] oldFirst = this.firstElements;
        Object[] oldSecond = this.secondElements;
        for (newSize = this.firstElements.length * 2; newSize < space; newSize *= 2) {
        }
        this.firstElements = new Object[newSize];
        this.secondElements = new Object[newSize];
        System.arraycopy(oldFirst, 0, this.firstElements, 0, this.size);
        System.arraycopy(oldSecond, 0, this.secondElements, 0, this.size);
    }

    public S getFirst(int i) {
        this.checkWithinBounds(i);
        return (S)this.firstElements[i];
    }

    private void checkWithinBounds(int i) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException("Out of bounds: " + i);
        }
    }

    public void setFirst(int i, S value) {
        this.checkWithinBounds(i);
        this.firstElements[i] = value;
    }

    public T getSecond(int i) {
        this.checkWithinBounds(i);
        return (T)this.secondElements[i];
    }

    public void setSecond(int i, T value) {
        this.checkWithinBounds(i);
        this.secondElements[i] = value;
    }

    public List<S> extractFirstList() {
        ArrayList<Object> result = new ArrayList<Object>(this.size + 1);
        for (int i = 0; i < this.size; ++i) {
            result.add(this.firstElements[i]);
        }
        return result;
    }

    public List<T> extractSecondList() {
        ArrayList<Object> result = new ArrayList<Object>(this.size + 1);
        for (int i = 0; i < this.size; ++i) {
            result.add(this.secondElements[i]);
        }
        return result;
    }

    public void swapPairs() {
        Object[] temp = this.firstElements;
        this.firstElements = this.secondElements;
        this.secondElements = temp;
    }

    public void clear() {
        this.size = 0;
    }

    public void removeLast() {
        CCSMPre.isTrue(this.size > 0, "Size must be positive!");
        --this.size;
    }
}

