/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.collections;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.collections.HashedListMap;
import edu.tum.cs.commons.collections.UnmodifiableList;
import edu.tum.cs.commons.collections.UnmodifiableSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableHashedListMap<K, I>
extends HashedListMap<K, I> {
    private final HashedListMap<K, I> map;

    public UnmodifiableHashedListMap(HashedListMap<K, I> map) {
        if (map == null) {
            throw new IllegalArgumentException("Underlying map may not be null!");
        }
        this.map = map;
    }

    @Override
    public List<I> createList(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnmodifiableList<I> getList(K key) {
        List<I> list = this.map.getList(key);
        if (list == null) {
            return null;
        }
        return CollectionUtils.asUnmodifiable(list);
    }

    @Override
    public void add(K key, I item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsList(K key) {
        return this.map.containsList(key);
    }

    @Override
    public UnmodifiableSet<K> getKeys() {
        return CollectionUtils.asUnmodifiable(this.map.getKeys());
    }

    @Override
    public UnmodifiableList<I> getValues() {
        return CollectionUtils.asUnmodifiable(this.map.getValues());
    }
}

