/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.digest;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.error.EnvironmentError;
import edu.tum.cs.commons.string.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Digester {
    private static MessageDigest digester = Digester.getMD5();

    public static String createMD5Digest(String base) {
        digester.reset();
        digester.update(base.getBytes());
        return StringUtils.encodeAsHex(digester.digest());
    }

    public static String createMD5Digest(Collection<String> bases) {
        List<String> sortedBases = CollectionUtils.sort(bases);
        return Digester.createMD5Digest(StringUtils.concat(sortedBases, ""));
    }

    public static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new EnvironmentError("MD5 algorithm found. Please check your JRE installation", e);
        }
    }
}

