/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.digest;

import edu.tum.cs.commons.assertion.CCSMPre;
import edu.tum.cs.commons.string.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MD5Digest
implements Serializable,
Comparable<MD5Digest> {
    private byte[] digest;
    public static final int MD5_BYTES = 16;

    public MD5Digest(MessageDigest digester) {
        this.digest = digester.digest();
        CCSMPre.isTrue(this.digest.length == 16, "Invalid digester used; not MD5");
    }

    public MD5Digest(byte[] digest) {
        CCSMPre.isTrue(digest.length == 16, "Invalid size of MD5 digest!");
        this.digest = (byte[])digest.clone();
    }

    public void insertIntoDigester(MessageDigest md) {
        md.update(this.digest);
    }

    public int hashCode() {
        return Arrays.hashCode(this.digest);
    }

    public int partialHashCode() {
        return this.digest[0] | this.digest[1] << 8 | this.digest[2] << 16;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MD5Digest)) {
            return false;
        }
        return Arrays.equals(this.digest, ((MD5Digest)o).digest);
    }

    @Override
    public int compareTo(MD5Digest o) {
        if (o == null) {
            return -1;
        }
        int lengthDelta = this.digest.length - o.digest.length;
        if (lengthDelta != 0) {
            return lengthDelta;
        }
        for (int i = 0; i < this.digest.length; ++i) {
            int delta = this.digest[i] - o.digest[i];
            if (delta == 0) continue;
            return delta;
        }
        return 0;
    }

    public byte[] getBytes() {
        return (byte[])this.digest.clone();
    }

    public String toString() {
        return StringUtils.encodeAsHex(this.digest);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeByte(this.digest.length);
        out.write(this.digest);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        int size = in.readByte();
        this.digest = new byte[size];
        for (int pos = 0; pos < size; pos += in.read(this.digest, pos, size - pos)) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Comparator
    implements java.util.Comparator<MD5Digest>,
    Serializable {
        @Override
        public int compare(MD5Digest o1, MD5Digest o2) {
            return o1.compareTo(o2);
        }
    }
}

