/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.filesystem;

import edu.tum.cs.commons.filesystem.FileSystemUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;

public class CanonicalFile
extends File {
    public CanonicalFile(File file) throws IOException {
        super(file.getCanonicalPath());
    }

    public CanonicalFile(String pathname) throws IOException {
        super(new File(pathname).getCanonicalPath());
    }

    public CanonicalFile(File parent, String child) throws IOException {
        this(new File(parent, child));
    }

    public CanonicalFile(String parent, String child) throws IOException {
        this(new File(parent, child));
    }

    public CanonicalFile(URI uri) throws IOException {
        super(new File(uri).getCanonicalPath());
    }

    @Deprecated
    public CanonicalFile getAbsoluteFile() {
        return this;
    }

    public CanonicalFile getCanonicalFile() {
        return this;
    }

    public CanonicalFile[] listFiles() {
        return this.canonize(super.listFiles());
    }

    public CanonicalFile[] listFiles(FileFilter filter) {
        File[] files = super.listFiles(filter);
        CanonicalFile[] result = new CanonicalFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.canonize(files[i].getAbsoluteFile());
        }
        return result;
    }

    public CanonicalFile[] listFiles(FilenameFilter filter) {
        return this.canonize(super.listFiles(filter));
    }

    public CanonicalFile getParentFile() {
        File parent = super.getParentFile();
        if (parent == null) {
            return null;
        }
        return this.canonize(parent);
    }

    public boolean isReadableFile() {
        return this.isFile() && this.canRead();
    }

    public String getCanonicalPath() {
        return super.getPath();
    }

    @Deprecated
    public String getAbsolutePath() {
        return super.getPath();
    }

    @Deprecated
    public String getPath() {
        return super.getPath();
    }

    public String getExtension() {
        return FileSystemUtils.getFileExtension(this);
    }

    private CanonicalFile[] canonize(File[] files) {
        CanonicalFile[] result = new CanonicalFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.canonize(files[i]);
        }
        return result;
    }

    private CanonicalFile canonize(File file) {
        try {
            return new CanonicalFile(file);
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Problems creating canonical path for " + file + ": " + e.getMessage()));
        }
    }
}

