/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.html;

import edu.tum.cs.commons.collections.TwoDimHashMap;
import edu.tum.cs.commons.html.CSSDeclarationBlock;
import edu.tum.cs.commons.html.ECSSPseudoClass;
import edu.tum.cs.commons.html.EHTMLAttribute;
import edu.tum.cs.commons.html.EHTMLElement;
import java.io.PrintStream;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class CSSManagerBase {
    private final TwoDimHashMap<EHTMLElement, ECSSPseudoClass, CSSDeclarationBlock> defaultDeclarations = new TwoDimHashMap();
    private final Map<CSSDeclarationBlock, String> classNames = new IdentityHashMap<CSSDeclarationBlock, String>();
    private static int classCounter = 0;

    public boolean hasDefaultDeclaration(EHTMLElement element) {
        return this.hasDefaultDeclaration(element, ECSSPseudoClass.NONE);
    }

    public boolean hasDefaultDeclaration(EHTMLElement element, ECSSPseudoClass pseudoClass) {
        return this.defaultDeclarations.containsKey(element, pseudoClass);
    }

    public final void addDefaultDeclaration(EHTMLElement element, CSSDeclarationBlock block) {
        this.addDefaultDeclaration(element, ECSSPseudoClass.NONE, block);
    }

    public void addDefaultDeclaration(EHTMLElement element, ECSSPseudoClass pseudoClass, CSSDeclarationBlock block) {
        if (this.defaultDeclarations.containsKey(element, pseudoClass)) {
            throw new IllegalStateException("May not add element " + (Object)((Object)element) + " twice.");
        }
        if (!element.allowsAttribute(EHTMLAttribute.STYLE)) {
            throw new IllegalArgumentException("The given element " + element.getName() + " does not support styles!");
        }
        this.defaultDeclarations.putValue(element, pseudoClass, block);
    }

    public String getCSSClassName(CSSDeclarationBlock block) {
        String name = this.classNames.get(block);
        if (name == null) {
            name = this.generateCSSClassName();
            this.classNames.put(block, name);
        }
        return name;
    }

    protected String generateCSSClassName() {
        return "CSSCLASS" + ++classCounter;
    }

    protected void writeOut(PrintStream ps) {
        this.writeOutDefaultDeclarations(ps);
        this.writeOutDeclarations(ps);
    }

    protected void writeOutDefaultDeclarations(PrintStream ps) {
        for (EHTMLElement element : this.defaultDeclarations.getFirstKeys()) {
            for (ECSSPseudoClass pseudocssClass : this.defaultDeclarations.getSecondKeys(element)) {
                String selector = element.getName() + pseudocssClass.getName();
                this.writeBlock(this.defaultDeclarations.getValue(element, pseudocssClass), selector, ps);
            }
        }
    }

    protected void writeOutDeclarations(PrintStream ps) {
        for (Map.Entry<CSSDeclarationBlock, String> entry : this.classNames.entrySet()) {
            this.writeBlock(entry.getKey(), "." + entry.getValue(), ps);
        }
    }

    private void writeBlock(CSSDeclarationBlock block, String selector, PrintStream ps) {
        ps.print(selector);
        ps.println(" {");
        block.writeOut(ps, "  ");
        ps.println("}");
        ps.println();
    }
}

