/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.io;

import edu.tum.cs.commons.io.StreamReaderThread;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ProcessUtils {
    public static ExecutionResult execute(String[] completeArguments) throws IOException {
        return ProcessUtils.execute(completeArguments, null);
    }

    public static ExecutionResult execute(String[] completeArguments, String input) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(completeArguments);
        return ProcessUtils.execute(builder, input);
    }

    public static ExecutionResult execute(ProcessBuilder builder) throws IOException {
        return ProcessUtils.execute(builder, null);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input) throws IOException {
        Process process = builder.start();
        StreamReaderThread stderrReader = new StreamReaderThread(process.getErrorStream());
        StreamReaderThread stdoutReader = new StreamReaderThread(process.getInputStream());
        if (input != null) {
            OutputStreamWriter stdIn = new OutputStreamWriter(process.getOutputStream());
            stdIn.write(input);
            ((Writer)stdIn).close();
        }
        try {
            process.waitFor();
            stderrReader.join();
            stdoutReader.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return new ExecutionResult(stdoutReader.getContent(), stderrReader.getContent(), process.exitValue());
    }

    public static class ExecutionResult {
        private final String stdout;
        private final String stderr;
        private final int returnCode;

        private ExecutionResult(String stdout, String stderr, int returnCode) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.returnCode = returnCode;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

