/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.math;

import edu.tum.cs.commons.math.IAggregator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MedianAggregator
implements IAggregator {
    @Override
    public double aggregate(Collection<? extends Number> values) {
        if (values.isEmpty()) {
            return Double.NaN;
        }
        ArrayList<Double> doubleValues = new ArrayList<Double>();
        for (Number number : values) {
            doubleValues.add(number.doubleValue());
        }
        Collections.sort(doubleValues);
        if (doubleValues.size() % 2 == 1) {
            int medianIndex = (int)Math.ceil(doubleValues.size() / 2);
            return (Double)doubleValues.get(medianIndex);
        }
        int lowerMedianIndex = doubleValues.size() / 2 - 1;
        double d = (Double)doubleValues.get(lowerMedianIndex);
        double upperMedian = (Double)doubleValues.get(lowerMedianIndex + 1);
        return (d + upperMedian) / 2.0;
    }

    @Override
    public double getNeutralElement() {
        return Double.NaN;
    }
}

