/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.math;

import edu.tum.cs.commons.assertion.CCSMPre;
import edu.tum.cs.commons.string.StringUtils;
import java.text.NumberFormat;

public class Range {
    private final double lower;
    private final double upper;
    private final boolean lowerIsInclusive;
    private final boolean upperIsInclusive;

    public Range(double lower, double upper) {
        this(lower, true, upper, true);
    }

    public Range(double lower, boolean lowerIsInclusive, double upper, boolean upperIsInclusive) {
        CCSMPre.isFalse(Double.isNaN(lower), "Lower bound must not be NaN");
        CCSMPre.isFalse(Double.isNaN(upper), "Upper bound must not be NaN");
        this.lower = lower;
        this.lowerIsInclusive = lowerIsInclusive;
        this.upper = upper;
        this.upperIsInclusive = upperIsInclusive;
    }

    public boolean contains(double number) {
        if (this.lowerIsInclusive ? number < this.lower : number <= this.lower) {
            return false;
        }
        return !(this.upperIsInclusive ? number > this.upper : number >= this.upper);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int result = this.hash(this.upper) + 37 * this.hash(this.lower);
        if (this.lowerIsInclusive) {
            result ^= 0x100000;
        }
        if (this.upperIsInclusive) {
            result ^= 0x4000;
        }
        return result;
    }

    private int hash(double number) {
        long bits = Double.doubleToLongBits(number);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        return this.lowerIsInclusive == other.lowerIsInclusive && this.upperIsInclusive == other.upperIsInclusive && this.lower == other.lower && this.upper == other.upper;
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public boolean isLowerInclusive() {
        return this.lowerIsInclusive;
    }

    public boolean isUpperInclusive() {
        return this.upperIsInclusive;
    }

    public boolean isEmpty() {
        if (this.lowerIsInclusive && this.upperIsInclusive) {
            return this.lower > this.upper;
        }
        return this.lower >= this.upper;
    }

    public double size() {
        return Math.max(0.0, this.upper - this.lower);
    }

    public String toString() {
        return this.format(null);
    }

    public String format(NumberFormat numberFormat) {
        StringBuilder result = new StringBuilder();
        if (this.lowerIsInclusive) {
            result.append("[");
        } else {
            result.append("]");
        }
        result.append(StringUtils.format(this.lower, numberFormat) + ";" + StringUtils.format(this.upper, numberFormat));
        if (this.upperIsInclusive) {
            result.append("]");
        } else {
            result.append("[");
        }
        return result.toString();
    }
}

