/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;

public class SmartRMISocketFactory
extends RMISocketFactory {
    private final int timeoutSeconds;

    public SmartRMISocketFactory() {
        this(-1);
    }

    public SmartRMISocketFactory(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = SmartRMISocketFactory.getDefaultSocketFactory().createSocket(host, port);
        if (this.timeoutSeconds > 0) {
            socket.setSoTimeout(this.timeoutSeconds * 1000);
        }
        return socket;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket socket = SmartRMISocketFactory.getDefaultSocketFactory().createServerSocket(port);
        socket.setReuseAddress(true);
        return socket;
    }
}

