/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.reflect;

import edu.tum.cs.commons.assertion.CCSMPre;
import edu.tum.cs.commons.collections.IdentityHashSet;
import edu.tum.cs.commons.collections.UniqueIdManager;
import edu.tum.cs.commons.color.ECCSMColor;
import edu.tum.cs.commons.string.StringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderGraphCreator {
    public static final String HEADER = "digraph G {" + StringUtils.CR + "  edge [  fontname = \"Helvetica\"," + StringUtils.CR + "          color = \"#639CCE\", fontsize = 8 ];" + StringUtils.CR + "  node [  shape = polygon," + StringUtils.CR + "          sides = 4," + StringUtils.CR + "          color = \"#639CCE\"," + StringUtils.CR + "          fontname = \"Helvetica\"," + StringUtils.CR + "          fontsize    = 9," + StringUtils.CR + "          height=0.25];" + StringUtils.CR;
    private final UniqueIdManager<Object> idManager = new UniqueIdManager();
    private final IdentityHashSet<Object> objects = new IdentityHashSet();
    private final IdentityHashSet<Class<?>> classes = new IdentityHashSet();
    private final IdentityHashSet<ClassLoader> classLoaders = new IdentityHashSet();

    public ClassLoaderGraphCreator(Object ... objects) {
        for (Object object : objects) {
            if (object instanceof Class) {
                this.addClass((Class)object);
                continue;
            }
            this.addObject(object);
        }
    }

    public void addObject(Object object) {
        CCSMPre.isFalse(object == null, "Object may not be null.");
        this.objects.add(object);
        this.addClass(object.getClass());
    }

    public void addClass(Class<?> clazz) {
        CCSMPre.isFalse(clazz == null, "Class may not be null.");
        this.classes.add(clazz);
        this.classLoaders.addAll(ClassLoaderGraphCreator.getClassLoaders(clazz));
    }

    private static List<ClassLoader> getClassLoaders(Class<?> clazz) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (ClassLoader loader = clazz.getClassLoader(); loader != null; loader = loader.getParent()) {
            loaders.add(loader);
        }
        loaders.add(null);
        return loaders;
    }

    public String createClassLoaderGraph() {
        StringBuilder builder = new StringBuilder();
        builder.append(HEADER + StringUtils.CR);
        builder.append(this.createVertices());
        builder.append(this.createEdges());
        builder.append("}" + StringUtils.CR);
        return builder.toString();
    }

    private String createEdges() {
        StringBuilder result = new StringBuilder();
        for (Object object : this.objects) {
            this.appendEdge(result, object, object.getClass());
        }
        for (Class clazz : this.classes) {
            this.appendEdge(result, clazz, clazz.getClassLoader());
        }
        for (ClassLoader classLoader : this.classLoaders) {
            if (classLoader == null) continue;
            this.appendEdge(result, classLoader, classLoader.getParent());
        }
        return result.toString();
    }

    private void appendEdge(StringBuilder builder, Object start, Object end) {
        String edge = this.makeId(start) + " -> " + this.makeId(end) + ";" + StringUtils.CR;
        builder.append(edge);
    }

    private String createVertices() {
        StringBuilder result = new StringBuilder();
        for (Object object : this.objects) {
            result.append(this.createVertex(object, ECCSMColor.GREEN));
        }
        for (Class clazz : this.classes) {
            result.append(this.createVertex(clazz, ECCSMColor.RED));
        }
        for (ClassLoader classLoader : this.classLoaders) {
            result.append(this.createVertex(classLoader, ECCSMColor.BLUE));
        }
        return result.toString();
    }

    private String createVertex(Object node, ECCSMColor color) {
        StringBuilder result = new StringBuilder();
        result.append(this.makeId(node));
        result.append(" [label=\"" + this.makeLabel(node) + "\", ");
        result.append(" color=\"" + color.getHTMLColorCode() + "\"");
        result.append("];" + StringUtils.CR);
        return result.toString();
    }

    private String makeLabel(Object object) {
        String result;
        if (object == null) {
            result = "Bootstrap Loader";
        } else if (object instanceof Class) {
            result = ((Class)object).getName();
        } else if (object instanceof ClassLoader) {
            result = object.toString();
        } else {
            String toString = object.toString();
            if (StringUtils.isEmpty(toString)) {
                toString = "instance of " + object.getClass().getName();
            }
            result = toString;
        }
        result = StringUtils.replaceLineBreaks(result, " ");
        result = result.replace('\"', '\'');
        return result;
    }

    private String makeId(Object object) {
        return "id" + this.idManager.obtainId(object);
    }
}

