/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTypeResolver {
    private final Map<TypeVariable<?>, Class<?>> parameterLookup = new HashMap();

    public GenericTypeResolver(Class<?> clazz) {
        if (clazz.getTypeParameters().length != 0) {
            throw new IllegalArgumentException("This only works for non-generic classes!");
        }
        this.fillParamMap(clazz);
    }

    private void fillParamMap(Class<?> clazz) {
        Type[] genericInterfaces;
        Class<?>[] interfaces;
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            Type superType = clazz.getGenericSuperclass();
            this.fillInParameters(superClass, superType);
            this.fillParamMap(superClass);
        }
        this.check((interfaces = clazz.getInterfaces()).length == (genericInterfaces = clazz.getGenericInterfaces()).length, "Interface lists should be equally long!");
        for (int i = 0; i < interfaces.length; ++i) {
            this.fillInParameters(interfaces[i], genericInterfaces[i]);
            this.fillParamMap(interfaces[i]);
        }
    }

    private void fillInParameters(Class<?> clazz, Type type) {
        if (type instanceof ParameterizedType) {
            TypeVariable<Class<?>>[] typeParameters;
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            this.check(actualTypeArguments.length == (typeParameters = clazz.getTypeParameters()).length, "Type parameters and actual arguments should be equally long!");
            for (int i = 0; i < typeParameters.length; ++i) {
                this.parameterLookup.put(typeParameters[i], this.resolveGenericType(actualTypeArguments[i]));
            }
        }
    }

    public Class<?> resolveGenericType(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof TypeVariable) {
            this.check(this.parameterLookup.containsKey(genericType), "All generic parameters should be bound.");
            return this.parameterLookup.get(genericType);
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getRawType();
        }
        this.check(false, "Generic types should be either concrete classes, type variables, or parametrized types: " + genericType.getClass());
        return null;
    }

    private void check(boolean assumedCondition, String errorMessage) {
        if (!assumedCondition) {
            throw new IllegalStateException(errorMessage);
        }
    }
}

