/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.commons.xml;

import edu.tum.cs.commons.assertion.CCSMAssert;
import edu.tum.cs.commons.collections.BidirectionalMap;
import edu.tum.cs.commons.xml.XMLUtils;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathEvaluator {
    private final XPath xPath = XPathFactory.newInstance().newXPath();
    private final NSContext nsContext = new NSContext();

    public XPathEvaluator() {
        this.xPath.setNamespaceContext(this.nsContext);
    }

    public void addNamespace(String prefix, String uri) {
        this.nsContext.addNamespace(prefix, uri);
    }

    public Object select(String expr, Element context, QName returnType) {
        try {
            return this.xPath.evaluate(expr, context, returnType);
        }
        catch (XPathExpressionException e) {
            CCSMAssert.fail(e.getMessage());
            return null;
        }
    }

    public List<Element> selectList(String expr, Element context) {
        return XMLUtils.elementNodes(this.selectNodeList(expr, context));
    }

    public NodeList selectNodeList(String expr, Element context) {
        return (NodeList)this.select(expr, context, XPathConstants.NODESET);
    }

    public Element selectElement(String expr, Element context) {
        return (Element)this.select(expr, context, XPathConstants.NODE);
    }

    public String selectString(String expr, Element context) {
        return (String)this.select(expr, context, XPathConstants.STRING);
    }

    public double selectDouble(String expr, Element context) {
        return (Double)this.select(expr, context, XPathConstants.NUMBER);
    }

    public int selectInt(String expr, Element context) {
        return ((Double)this.select(expr, context, XPathConstants.NUMBER)).intValue();
    }

    public boolean selectBoolean(String expr, Element context) {
        return (Boolean)this.select(expr, context, XPathConstants.BOOLEAN);
    }

    private static class NSContext
    implements NamespaceContext {
        private final BidirectionalMap<String, String> map = new BidirectionalMap();

        private NSContext() {
        }

        private void addNamespace(String prefix, String uri) {
            this.map.put(prefix, uri);
        }

        public String getNamespaceURI(String prefix) {
            return this.map.getSecond(prefix);
        }

        public String getPrefix(String namespaceURI) {
            return this.map.getFirst(namespaceURI);
        }

        public Iterator getPrefixes(String namespaceURI) {
            return this.map.getFirstSet().iterator();
        }
    }
}

