/*
 * Decompiled with CFR 0.152.
 */
package edu.tum.cs.scanner;

import edu.tum.cs.scanner.ETokenType;
import edu.tum.cs.scanner.IScanner;
import edu.tum.cs.scanner.IToken;
import edu.tum.cs.scanner.ScannerException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SyntaxHighlightingView
extends PlainView {
    private final IScanner scanner;
    private final HashMap<ETokenType.ETokenClass, Color> colorMap;
    private final HashMap<ETokenType.ETokenClass, Integer> styleMap;

    public SyntaxHighlightingView(Element element, IScanner scanner, HashMap<ETokenType.ETokenClass, Color> colorMap, HashMap<ETokenType.ETokenClass, Integer> styleMap) {
        super(element);
        this.scanner = scanner;
        this.colorMap = colorMap;
        this.styleMap = styleMap;
    }

    @Override
    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        return this.drawUnselectedText(g, x, y, p0, p1);
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int x, int y, int startIndex, int endIndex) throws BadLocationException {
        String text = this.getDocument().getText(startIndex, endIndex - startIndex);
        this.scanner.reset(new StringReader(text), null);
        IToken lastToken = null;
        try {
            IToken token;
            while ((token = this.scanner.getNextToken()).getType() != ETokenType.EOF) {
                x = this.handleWhitespace(graphics, x, y, startIndex, token, lastToken);
                x = this.drawText(startIndex + token.getOffset(), token.getText().length(), graphics, x, y, token);
                lastToken = token;
            }
        }
        catch (ScannerException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        if (lastToken != null) {
            int index = startIndex + lastToken.getOffset() + lastToken.getText().length();
            return this.drawTextPlain(index, endIndex - index, graphics, x, y);
        }
        return super.drawSelectedText(graphics, x, y, startIndex, endIndex);
    }

    private int drawText(int offset, int length, Graphics graphics, int x, int y, Color color, int style) throws BadLocationException {
        graphics.setColor(color);
        graphics.setFont(graphics.getFont().deriveFont(style));
        this.getDocument().getText(offset, length, this.getLineBuffer());
        return Utilities.drawTabbedText(this.getLineBuffer(), x, y, graphics, (TabExpander)this, offset);
    }

    private int drawText(int offset, int length, Graphics graphics, int x, int y, IToken token) throws BadLocationException {
        return this.drawText(offset, length, graphics, x, y, this.getColor(token), this.getStyle(token));
    }

    private int drawTextPlain(int offset, int length, Graphics graphics, int x, int y) throws BadLocationException {
        return this.drawText(offset, length, graphics, x, y, Color.black, 0);
    }

    private Color getColor(IToken token) {
        Color color = this.colorMap.get((Object)token.getType().getTokenClass());
        if (color != null) {
            return color;
        }
        return Color.BLACK;
    }

    private int getStyle(IToken token) {
        Integer style = this.styleMap.get((Object)token.getType().getTokenClass());
        if (style != null) {
            return style;
        }
        return 0;
    }

    private int handleWhitespace(Graphics g, int x, int y, int startIndex, IToken token, IToken lastToken) throws BadLocationException {
        if (lastToken == null) {
            int whitespace = token.getOffset();
            if (whitespace > 0) {
                return this.drawTextPlain(startIndex, whitespace, g, x, y);
            }
            return x;
        }
        int whitespace = token.getOffset() - (lastToken.getOffset() + lastToken.getText().length());
        if (whitespace > 0) {
            return this.drawTextPlain(startIndex + lastToken.getOffset() + lastToken.getText().length(), whitespace, g, x, y);
        }
        return x;
    }
}

