/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.clone.IDeepCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assessment
implements Cloneable,
IDeepCloneable,
Serializable {
    private final int[] mapping = new int[ETrafficLightColor.values().length];

    public Assessment() {
    }

    public Assessment(ETrafficLightColor color) {
        this.add(color);
    }

    public final void add(ETrafficLightColor color) {
        this.add(color, 1);
    }

    public final void add(ETrafficLightColor color, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be non-negative!");
        }
        int n = color.ordinal();
        this.mapping[n] = this.mapping[n] + count;
    }

    public final void add(Assessment a) {
        for (int i = 0; i < this.mapping.length; ++i) {
            int n = i;
            this.mapping[n] = this.mapping[n] + a.mapping[i];
        }
    }

    public int getColorFrequency(ETrafficLightColor color) {
        return this.mapping[color.ordinal()];
    }

    public ETrafficLightColor getDominantColor() {
        for (int i = 0; i < ETrafficLightColor.values().length; ++i) {
            if (this.mapping[i] <= 0) continue;
            return ETrafficLightColor.values()[i];
        }
        return ETrafficLightColor.UNKNOWN;
    }

    public ETrafficLightColor getMostFrequentColor() {
        ETrafficLightColor result = ETrafficLightColor.UNKNOWN;
        int bestCount = 0;
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] <= bestCount) continue;
            bestCount = this.mapping[i];
            result = ETrafficLightColor.values()[i];
        }
        return result;
    }

    public String toString() {
        int sum = this.getSize();
        if (sum == 0) {
            return "";
        }
        if (sum == 1) {
            return this.getDominantColor().toString();
        }
        StringBuilder builder = new StringBuilder("[");
        this.appendColor(builder, ETrafficLightColor.GREEN);
        builder.append(", ");
        this.appendColor(builder, ETrafficLightColor.YELLOW);
        builder.append(", ");
        this.appendColor(builder, ETrafficLightColor.RED);
        if (this.getColorFrequency(ETrafficLightColor.BASELINE) > 0) {
            builder.append(", ");
            this.appendColor(builder, ETrafficLightColor.BASELINE);
        }
        builder.append("]");
        return builder.toString();
    }

    public int getSize() {
        int sum = 0;
        for (int i = 0; i < this.mapping.length; ++i) {
            sum += this.mapping[i];
        }
        return sum;
    }

    private void appendColor(StringBuilder builder, ETrafficLightColor color) {
        builder.append(color.toString().substring(0, 1));
        builder.append(": ");
        builder.append(this.getColorFrequency(color));
    }

    protected Assessment clone() {
        return this.deepClone();
    }

    @Override
    public Assessment deepClone() {
        Assessment a = new Assessment();
        a.add(this);
        return a;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Assessment)) {
            return false;
        }
        Assessment a = (Assessment)obj;
        return Arrays.equals(this.mapping, a.mapping);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.mapping.length; ++i) {
            hash *= 97;
            hash += this.mapping[i];
            hash %= 0x3000005;
        }
        return hash;
    }

    public static Assessment aggregate(Collection<Assessment> values) {
        Assessment result = new Assessment();
        for (Assessment a : values) {
            result.add(a);
        }
        return result;
    }
}

