/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.security.MessageDigest;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.digest.Digester;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rating {
    public static final String RATING_TAG = "@ConQAT.Rating";
    private static final String OLD_RATING_TAG = "@levd.rating";
    private static final String COLORS_REGEX = StringUtils.concat((Object[])ETrafficLightColor.values(), "|");
    private static final Pattern RATING_PATTERN = Pattern.compile("(@ConQAT.Rating|@levd.rating) +(" + COLORS_REGEX + ") +Hash:? *([a-fA-F0-9]*)", 2);
    private static final Pattern RESET_PATTERN = Pattern.compile("^package .*;$");
    private ETrafficLightColor storedRating;
    private boolean oldStyleRating = false;
    private String storedHash;
    private String expectedHash;

    public Rating(String content) {
        this(content, null);
    }

    public Rating(String content, ETrafficLightColor forcedRating) {
        this(StringUtils.splitLinesAsList(content), forcedRating);
    }

    public Rating(List<String> lines) {
        this(lines, null);
    }

    public Rating(List<String> lines, ETrafficLightColor forcedRating) {
        MessageDigest md5 = Digester.getMD5();
        for (String line : lines) {
            if (this.storedRating == null && this.checkRating(line)) continue;
            this.updateHash(line, md5);
        }
        if (forcedRating != null) {
            this.storedRating = forcedRating;
            this.oldStyleRating = false;
        }
        if (!this.oldStyleRating && this.storedRating != null) {
            md5.update(StringUtils.stringToBytes(this.storedRating.name()));
        }
        this.expectedHash = StringUtils.encodeAsHex(md5.digest());
    }

    private boolean checkRating(String line) {
        Matcher ratingMatcher = RATING_PATTERN.matcher(line);
        if (!ratingMatcher.find()) {
            return false;
        }
        this.oldStyleRating = ratingMatcher.group(1).equalsIgnoreCase(OLD_RATING_TAG);
        this.storedRating = EnumUtils.valueOf(ETrafficLightColor.class, ratingMatcher.group(2));
        this.storedHash = ratingMatcher.group(3);
        return true;
    }

    private void updateHash(String line, MessageDigest md5) {
        if (line.contains(RATING_TAG) || line.contains(OLD_RATING_TAG)) {
            return;
        }
        if (RESET_PATTERN.matcher(line).matches()) {
            md5.reset();
            return;
        }
        boolean inDollar = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '$') {
                inDollar = !inDollar;
                continue;
            }
            if (inDollar || c <= ' ' || c >= '\u0080') continue;
            md5.update((byte)c);
        }
    }

    public ETrafficLightColor getStoredRating() {
        return this.storedRating;
    }

    public ETrafficLightColor getRating() {
        if (this.getStoredRating() == null || !this.isValidRating()) {
            return ETrafficLightColor.RED;
        }
        return this.getStoredRating();
    }

    private boolean isValidRating() {
        return this.storedHash != null && this.storedHash.equalsIgnoreCase(this.expectedHash);
    }

    public String getExpectedHashString() {
        return this.expectedHash;
    }

    public static String updateRating(String content, ETrafficLightColor newColor) {
        Matcher m = RATING_PATTERN.matcher(content);
        if (!m.find()) {
            return null;
        }
        String replacement = Rating.constructRatingTag(newColor, new Rating(content, newColor).getExpectedHashString());
        StringBuffer sb = new StringBuffer();
        m.appendReplacement(sb, replacement);
        m.appendTail(sb);
        return sb.toString();
    }

    public static String constructRatingTag(ETrafficLightColor color, String hash) {
        return "@ConQAT.Rating " + color.name() + " Hash: " + hash;
    }
}

