/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.cache.CacheBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LRUCacheBase<I, H, E, X extends Exception>
extends CacheBase<I, H, E, X> {
    private final LinkedHashMap<H, E> cache;

    public LRUCacheBase(final int maxSize) {
        CCSMPre.isTrue(maxSize > 0, "Maximal size must be positive!");
        this.cache = new LinkedHashMap<H, E>(2 * maxSize, 0.6f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<H, E> eldest) {
                return this.size() > maxSize;
            }
        };
    }

    @Override
    public E getItem(I identifier) throws X {
        Object key = this.getHashKey(identifier);
        E value = this.cache.get(key);
        if (value == null) {
            value = this.obtainItem(identifier);
            this.cache.put(key, value);
        }
        return value;
    }
}

