/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j.backend;

import java.util.LinkedHashMap;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.cache4j.backend.ICacheBackend;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LRUCacheBackend<K, V>
implements ICacheBackend<K, V> {
    private final LinkedHashMap<K, V> cache;
    private final int maxCacheSize;

    public LRUCacheBackend(int maxSize) {
        CCSMPre.isTrue(maxSize > 0, "Maximal size must be positive!");
        this.maxCacheSize = maxSize;
        this.cache = new LinkedHashMap<K, V>(2 * maxSize, 0.6f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > LRUCacheBackend.this.maxCacheSize;
            }
        };
    }

    @Override
    public void store(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public V retrieve(K key) {
        return this.cache.get(key);
    }

    @Override
    public LRUCacheBackend<K, V> newInstance() {
        return new LRUCacheBackend<K, V>(this.maxCacheSize);
    }
}

