/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.lib.commons.clone.IDeepCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPatternList
extends ArrayList<Pattern>
implements IDeepCloneable,
Serializable {
    public BasicPatternList() {
    }

    public BasicPatternList(Collection<? extends Pattern> patterns) {
        super(patterns);
    }

    public BasicPatternList(Pattern ... patterns) {
        this((Collection<? extends Pattern>)Arrays.asList(patterns));
    }

    public boolean emptyOrMatchesAny(String s) {
        return this.isEmpty() || this.matchesAny(s);
    }

    public boolean matchesAny(String s) {
        for (Pattern p : this) {
            if (!p.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findsAnyIn(String s) {
        for (Pattern p : this) {
            if (!p.matcher(s).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public BasicPatternList deepClone() {
        return new BasicPatternList(this);
    }

    public List<String> asStringList() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (Pattern pattern : this) {
            patterns.add(pattern.pattern());
        }
        return patterns;
    }
}

