/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.conqat.lib.commons.assertion.CCSMAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedPriorityQueue<T>
extends PriorityQueue<T> {
    private int capacityBound;

    public BoundedPriorityQueue(int capacityBound) {
        super(capacityBound);
        this.setCapacityBound(capacityBound);
    }

    private void setCapacityBound(int capacityBound) throws AssertionError {
        CCSMAssert.isTrue(capacityBound > 0, "Capacity bound must be positive but was: " + capacityBound);
        this.capacityBound = capacityBound;
    }

    public BoundedPriorityQueue(int capacityBound, Comparator<T> comparator) {
        super(capacityBound, comparator);
        this.setCapacityBound(capacityBound);
    }

    @Override
    public boolean offer(T element) {
        boolean result = super.offer(element);
        if (this.size() > this.capacityBound) {
            this.remove();
        }
        CCSMAssert.isTrue(this.size() <= this.capacityBound, "Size exceeds capacity bound");
        return result;
    }
}

