/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.conqat.lib.commons.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayWrapper
implements Serializable,
Comparable<ByteArrayWrapper> {
    protected byte[] array;

    public ByteArrayWrapper(byte[] array) {
        this.array = (byte[])array.clone();
    }

    public byte[] getBytes() {
        return (byte[])this.array.clone();
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArrayWrapper) {
            return Arrays.equals(this.array, ((ByteArrayWrapper)obj).array);
        }
        if (obj instanceof byte[]) {
            return Arrays.equals(this.array, (byte[])obj);
        }
        return false;
    }

    public String toString() {
        return StringUtils.encodeAsHex(this.array);
    }

    @Override
    public int compareTo(ByteArrayWrapper o) {
        if (o == null) {
            return -1;
        }
        int lengthDelta = this.array.length - o.array.length;
        if (lengthDelta != 0) {
            return lengthDelta;
        }
        for (int i = 0; i < this.array.length; ++i) {
            int delta = this.array[i] - o.array[i];
            if (delta == 0) continue;
            return delta;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.array.length);
        out.write(this.array);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        int size = in.readInt();
        this.array = new byte[size];
        for (int pos = 0; pos < size; pos += in.read(this.array, pos, size - pos)) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Comparator
    implements java.util.Comparator<ByteArrayWrapper>,
    Serializable {
        @Override
        public int compare(ByteArrayWrapper o1, ByteArrayWrapper o2) {
            return o1.compareTo(o2);
        }
    }
}

