/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.conqat.lib.commons.collections.HashedListMap;
import org.conqat.lib.commons.collections.ISortableData;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SortableDataUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableHashedListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.collections.UnmodifiableSortedMap;
import org.conqat.lib.commons.collections.UnmodifiableSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private static final UnmodifiableList<?> EMPTY_LIST = new UnmodifiableList(Collections.EMPTY_LIST);
    private static final UnmodifiableMap<?, ?> EMPTY_MAP = new UnmodifiableMap(Collections.EMPTY_MAP);
    private static final UnmodifiableSet<?> EMPTY_SET = new UnmodifiableSet(Collections.EMPTY_SET);

    public static <T> HashSet<T> asHashSet(T ... elements) {
        HashSet result = new HashSet();
        Collections.addAll(result, elements);
        return result;
    }

    public static <T> UnmodifiableCollection<T> asUnmodifiable(Collection<T> c) {
        return new UnmodifiableCollection<T>(c);
    }

    @Deprecated
    public static <S, T> UnmodifiableHashedListMap<S, T> asUnmodifiable(HashedListMap<S, T> m) {
        return new UnmodifiableHashedListMap<S, T>(m);
    }

    public static <T> UnmodifiableList<T> asUnmodifiable(List<T> l) {
        return new UnmodifiableList<T>(l);
    }

    public static <S, T> UnmodifiableMap<S, T> asUnmodifiable(Map<S, T> m) {
        return new UnmodifiableMap<S, T>(m);
    }

    public static <T> UnmodifiableSet<T> asUnmodifiable(Set<T> s) {
        return new UnmodifiableSet<T>(s);
    }

    public static <S, T> UnmodifiableSortedMap<S, T> asUnmodifiable(SortedMap<S, T> m) {
        return new UnmodifiableSortedMap<S, T>(m);
    }

    public static <T> UnmodifiableSortedSet<T> asUnmodifiable(SortedSet<T> s) {
        return new UnmodifiableSortedSet<T>(s);
    }

    public static final <T> UnmodifiableList<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <S, T> UnmodifiableMap<S, T> emptyMap() {
        return EMPTY_MAP;
    }

    public static final <T> UnmodifiableSet<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T extends Comparable<? super T>> List<T> sort(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> reverse(Collection<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list, comparator);
        return list;
    }

    public static <T extends Comparable<T>> UnmodifiableList<T> asSortedUnmodifiableList(Collection<T> collection) {
        return CollectionUtils.asUnmodifiable(CollectionUtils.sort(collection));
    }

    public static <T extends Comparable<T>> UnmodifiableList<T> asSortedUnmodifiableList(Collection<T> collection, Comparator<? super T> comparator) {
        return CollectionUtils.asUnmodifiable(CollectionUtils.sort(collection, comparator));
    }

    public static <T> T getAny(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    public static <T> T[] toArray(Collection<? extends T> collection, Class<T> type) {
        Object[] result = (Object[])Array.newInstance(type, collection.size());
        Iterator<T> it = collection.iterator();
        for (int i = 0; i < collection.size(); ++i) {
            result[i] = it.next();
        }
        return result;
    }

    public static <T> T[] copyArray(T[] original) {
        return Arrays.copyOf(original, original.length);
    }

    public static <T> List<ImmutablePair<T, T>> computeUnorderedPairs(Collection<T> collection) {
        ArrayList<T> elements = new ArrayList<T>(collection);
        ArrayList<ImmutablePair<T, T>> pairs = new ArrayList<ImmutablePair<T, T>>();
        int size = elements.size();
        for (int firstIndex = 0; firstIndex < size; ++firstIndex) {
            for (int secondIndex = firstIndex + 1; secondIndex < size; ++secondIndex) {
                pairs.add(new ImmutablePair(elements.get(firstIndex), elements.get(secondIndex)));
            }
        }
        return pairs;
    }

    public static <T> T getLast(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list instanceof Deque) {
            return (T)((Deque)((Object)list)).getLast();
        }
        return list.get(list.size() - 1);
    }

    public static <T> List<T> getRest(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.subList(1, list.size());
    }

    public static <S extends Comparable<S>, T> void sortByFirst(final PairList<S, T> list) {
        SortableDataUtils.sort(new ISortableData(){

            public void swap(int i, int j) {
                list.swapEntries(i, j);
            }

            public int size() {
                return list.size();
            }

            public boolean isLess(int i, int j) {
                return ((Comparable)list.getFirst(i)).compareTo(list.getFirst(j)) < 0;
            }
        });
    }

    public static <T> List<T> asRandomAccessList(Collection<T> list) {
        if (list instanceof List && list instanceof RandomAccess) {
            return (List)list;
        }
        return new ArrayList<T>(list);
    }
}

