/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.IdentityHashMap;
import java.util.Map;
import org.conqat.lib.commons.collections.ImmutablePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityPairMap<T, V> {
    private final Map<T, Map<T, V>> map = new IdentityHashMap<T, Map<T, V>>();

    public void put(ImmutablePair<T, T> pair, V value) {
        this.put(pair.getFirst(), pair.getSecond(), value);
    }

    public void put(T t1, T t2, V value) {
        this.insert(t1, t2, value);
        this.insert(t2, t1, value);
    }

    private void insert(T t1, T t2, V value) {
        Map<T, V> m = this.map.get(t1);
        if (m == null) {
            m = new IdentityHashMap<T, V>();
            this.map.put(t1, m);
        }
        m.put(t2, value);
    }

    public boolean contains(ImmutablePair<T, T> pair) {
        return this.contains(pair.getFirst(), pair.getSecond());
    }

    public boolean contains(T t1, T t2) {
        Map<T, V> m = this.map.get(t1);
        if (m == null) {
            return false;
        }
        return m.containsKey(t2);
    }

    public V get(ImmutablePair<T, T> pair) {
        return this.get(pair.getFirst(), pair.getSecond());
    }

    public V get(T t1, T t2) {
        Map<T, V> m = this.map.get(t1);
        if (m == null) {
            return null;
        }
        return m.get(t2);
    }

    public void clear() {
        this.map.clear();
    }
}

