/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import org.conqat.lib.commons.collections.ISortableData;

public class SortableDataUtils {
    public static int binarySearch(ISortableData data, int elementIndex) {
        int lower = 0;
        int upper = data.size();
        while (lower < upper) {
            int mid = lower + upper >>> 1;
            if (data.isLess(mid, elementIndex)) {
                lower = mid + 1;
                continue;
            }
            upper = mid;
        }
        return lower;
    }

    public static void sort(ISortableData data) {
        SortableDataUtils.sort(data, 0, data.size());
    }

    private static void sort(ISortableData data, int begin, int end) {
        if (end - begin < 5) {
            SortableDataUtils.bubbleSort(data, begin, end);
            return;
        }
        int pivot = begin + (int)(Math.random() * (double)(end - begin));
        int lower = begin;
        int upper = end - 1;
        while (lower <= upper) {
            if (data.isLess(lower, pivot)) {
                ++lower;
                continue;
            }
            pivot = SortableDataUtils.swapFixPivot(data, lower, upper, pivot);
            --upper;
        }
        if (lower != pivot) {
            data.swap(lower, pivot);
        }
        SortableDataUtils.sort(data, begin, lower);
        SortableDataUtils.sort(data, lower + 1, end);
    }

    private static int swapFixPivot(ISortableData data, int i, int j, int pivot) {
        data.swap(i, j);
        if (i == pivot) {
            return j;
        }
        if (j == pivot) {
            return i;
        }
        return pivot;
    }

    static void bubbleSort(ISortableData data, int begin, int end) {
        for (int i = end - 1; i > begin; --i) {
            for (int j = begin; j < i; ++j) {
                if (!data.isLess(j + 1, j)) continue;
                data.swap(j, j + 1);
            }
        }
    }
}

