/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.color;

import java.awt.Color;
import java.util.regex.Pattern;
import org.conqat.lib.commons.color.ECCSMColor;
import org.conqat.lib.commons.enums.EnumUtils;

public class ColorUtils {
    private static Pattern HTML_COLOR_PATTERN = Pattern.compile("#[0-9a-f]{6}", 2);

    public static Color fromString(String s) {
        Enum color;
        if (HTML_COLOR_PATTERN.matcher(s).matches()) {
            return Color.decode("0x" + s.substring(1));
        }
        if (s.startsWith("ccsm-") && (color = EnumUtils.valueOfIgnoreCase(ECCSMColor.class, s.substring(5))) != null) {
            return ((ECCSMColor)color).getColor();
        }
        color = EnumUtils.valueOfIgnoreCase(EAWTColors.class, s);
        if (color != null) {
            return ((EAWTColors)color).getColor();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EAWTColors {
        RED(Color.RED),
        GREEN(Color.GREEN),
        BLUE(Color.BLUE),
        YELLOW(Color.YELLOW),
        ORANGE(Color.ORANGE),
        WHITE(Color.WHITE),
        BLACK(Color.BLACK),
        GRAY(Color.GRAY),
        CYAN(Color.CYAN),
        MAGENTA(Color.MAGENTA);

        private final Color color;

        private EAWTColors(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

