/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.constraint;

import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.constraint.ConstraintViolationException;
import org.conqat.lib.commons.constraint.ILocalConstraint;
import org.conqat.lib.commons.error.IExceptionHandler;
import org.conqat.lib.commons.error.RethrowingExceptionHandler;
import org.conqat.lib.commons.visitor.IMeshWalker;
import org.conqat.lib.commons.visitor.ITreeWalker;
import org.conqat.lib.commons.visitor.IVisitor;
import org.conqat.lib.commons.visitor.VisitorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidator {
    private final PairList<Class<?>, ILocalConstraint<?>> localConstraints = new PairList();

    public <T> void addConstraint(Class<? extends T> clazz, ILocalConstraint<T> constraint) {
        this.localConstraints.add(clazz, constraint);
    }

    public void checkConstaints(Object o) throws ConstraintViolationException {
        this.checkConstaints(o, RethrowingExceptionHandler.getInstance());
    }

    public <X extends Exception> void checkConstaints(Object o, IExceptionHandler<ConstraintViolationException, X> handler) throws X {
        Class<?> clazz = o.getClass();
        for (int i = 0; i < this.localConstraints.size(); ++i) {
            if (!this.localConstraints.getFirst(i).isAssignableFrom(clazz)) continue;
            ILocalConstraint<?> constraint = this.localConstraints.getSecond(i);
            try {
                constraint.checkLocalConstraint(o);
                continue;
            }
            catch (ConstraintViolationException e) {
                handler.handleException(e);
            }
        }
    }

    public <T, X_WALKER extends Exception> void validateTree(T root, ITreeWalker<T, X_WALKER> walker) throws ConstraintViolationException, X_WALKER {
        this.validateTree(root, walker, RethrowingExceptionHandler.getInstance());
    }

    public <T, X extends Exception, X_WALKER extends Exception> void validateTree(T root, ITreeWalker<T, X_WALKER> walker, IExceptionHandler<ConstraintViolationException, X> handler) throws X, X_WALKER {
        VisitorUtils.visitAllPreOrder(root, walker, new CheckVisitor(handler));
    }

    public <T, X_WALKER extends Exception> void validateMesh(T start, IMeshWalker<T, X_WALKER> walker) throws ConstraintViolationException, X_WALKER {
        this.validateMesh(start, walker, RethrowingExceptionHandler.getInstance());
    }

    public <T, X extends Exception, X_WALKER extends Exception> void validateMesh(T start, IMeshWalker<T, X_WALKER> walker, IExceptionHandler<ConstraintViolationException, X> handler) throws X, X_WALKER {
        VisitorUtils.visitAllDepthFirst(start, walker, new CheckVisitor(handler));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CheckVisitor<T, X extends Exception>
    implements IVisitor<T, X> {
        private final IExceptionHandler<ConstraintViolationException, X> handler;

        public CheckVisitor(IExceptionHandler<ConstraintViolationException, X> handler) {
            this.handler = handler;
        }

        @Override
        public void visit(T element) throws X {
            ConstraintValidator.this.checkConstaints(element, this.handler);
        }
    }
}

