/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateUtils {
    private static IFactory<Date, NeverThrownRuntimeException> nowFactory;

    public static Date getLatest(Collection<Date> dates) {
        if (dates.isEmpty()) {
            return null;
        }
        return Collections.max(dates);
    }

    public static Date getEarliest(Collection<Date> dates) {
        if (dates.isEmpty()) {
            return null;
        }
        return Collections.min(dates);
    }

    public static Date min(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        if (d1.compareTo(d2) < 0) {
            return d1;
        }
        return d2;
    }

    public static Date max(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        if (d2.compareTo(d1) > 0) {
            return d2;
        }
        return d1;
    }

    public static synchronized Date getNow() {
        if (nowFactory == null) {
            String property = System.getProperty("org.conqat.lib.commons.date.now");
            if (property == null) {
                nowFactory = new CurrentDateFactory();
            } else {
                try {
                    nowFactory = new FixedDateFactory(new SimpleDateFormat("yyyyMMddHHmmss").parse(property));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Invalid date string provided via system property: " + property, e);
                }
            }
        }
        return nowFactory.create();
    }

    public static synchronized IFactory<Date, NeverThrownRuntimeException> testcode_getNowFactory() {
        return nowFactory;
    }

    public static synchronized void testcode_setNowFactory(IFactory<Date, NeverThrownRuntimeException> nowFactory) {
        DateUtils.nowFactory = nowFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurrentDateFactory
    implements IFactory<Date, NeverThrownRuntimeException> {
        @Override
        public Date create() throws NeverThrownRuntimeException {
            return new Date();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FixedDateFactory
    implements IFactory<Date, NeverThrownRuntimeException> {
        private final Date now;

        public FixedDateFactory(Date now) {
            this.now = now;
        }

        @Override
        public Date create() throws NeverThrownRuntimeException {
            return (Date)this.now.clone();
        }
    }
}

