/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.error.EnvironmentError;
import org.conqat.lib.commons.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Digester {
    private static MessageDigest digester = Digester.getMD5();

    public static String createMD5Digest(String base) {
        return Digester.createMD5Digest(base.getBytes());
    }

    public static String createMD5Digest(byte[] data) {
        digester.reset();
        digester.update(data);
        return StringUtils.encodeAsHex(digester.digest());
    }

    public static String createMD5Digest(Collection<String> bases) {
        List<String> sortedBases = CollectionUtils.sort(bases);
        return Digester.createMD5Digest(StringUtils.concat(sortedBases, ""));
    }

    public static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new EnvironmentError("MD5 algorithm found. Please check your JRE installation", e);
        }
    }
}

