/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashSet;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathUtils {
    public static String createClassPathAsString(IURLResolver resolver, Class<?> ... anchorClasses) throws IOException {
        return StringUtils.concat(ClassPathUtils.createClassPathAsSet(resolver, anchorClasses), File.pathSeparator);
    }

    public static String[] createClassPathAsArray(IURLResolver resolver, Class<?> ... anchorClasses) throws IOException {
        return ClassPathUtils.createClassPathAsSet(resolver, anchorClasses).toArray(new String[0]);
    }

    public static LinkedHashSet<String> createClassPathAsSet(IURLResolver resolver, Class<?> ... anchorClasses) throws IOException {
        LinkedHashSet<String> classPath = new LinkedHashSet<String>();
        for (Class<?> clazz : anchorClasses) {
            classPath.add(ClassPathUtils.createClassPath(resolver, clazz));
        }
        return classPath;
    }

    public static String createClassPath(IURLResolver resolver, Class<?> anchorClass) throws IOException {
        String protocol;
        URL url = ClassPathUtils.obtainClassFileURL(anchorClass);
        if (url == null) {
            throw new AssertionError((Object)"Internal assumption violated.");
        }
        if (resolver != null) {
            url = resolver.resolve(url);
        }
        if ("file".equals(protocol = url.getProtocol())) {
            return ClassPathUtils.createFileClasspath(url, anchorClass);
        }
        if ("jar".equals(protocol)) {
            return FileSystemUtils.extractJarFileFromJarURL(url).getCanonicalPath();
        }
        throw new IOException("Unsupported protocol: " + protocol);
    }

    public static URL obtainClassFileURL(Class<?> clazz) {
        return clazz.getResource(clazz.getSimpleName() + ".class");
    }

    private static String createFileClasspath(URL url, Class<?> clazz) throws IOException {
        String path = url.getPath();
        path = path.substring(0, path.length() - 6 - clazz.getName().length());
        return new File(path).getCanonicalPath();
    }

    public static interface IURLResolver {
        public URL resolve(URL var1) throws IOException;
    }
}

