/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.conqat.lib.commons.filesystem.PathBasedContentProviderBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ZipContentProvider
extends PathBasedContentProviderBase {
    private final ZipFile zipFile;

    public ZipContentProvider(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public Collection<String> getPaths() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            result.add(entry.getName());
        }
        return result;
    }

    @Override
    public InputStream openStream(String relativePath) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(relativePath);
        if (entry == null) {
            throw new IOException("Unknown path: " + relativePath);
        }
        return this.zipFile.getInputStream(entry);
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }
}

