/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.html;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.conqat.lib.commons.html.CSSDeclarationBlock;
import org.conqat.lib.commons.html.CSSManagerBase;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriterException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLResolver;
import org.conqat.lib.commons.xml.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLWriter
extends XMLWriter<EHTMLElement, EHTMLAttribute> {
    private final CSSManagerBase cssManager;

    public HTMLWriter(File file, CSSManagerBase cssManager) throws IOException {
        this((OutputStream)new PrintStream(file, "UTF-8"), cssManager);
    }

    public HTMLWriter(OutputStream stream, CSSManagerBase cssManager) {
        super(new PrintWriter(HTMLWriter.wrapStream(stream)), new HTMLResolver());
        this.cssManager = cssManager;
    }

    private static OutputStreamWriter wrapStream(OutputStream stream) {
        try {
            return new OutputStreamWriter(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 should be supported!");
        }
    }

    public HTMLWriter(PrintWriter writer, CSSManagerBase cssManager) {
        super(writer, new HTMLResolver());
        this.cssManager = cssManager;
    }

    public void addStdHeader(String encoding) {
        this.addHeader("1.0", encoding);
        this.addPublicDocTypeDefintion(EHTMLElement.HTML, "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
    }

    public void addStdHeader() {
        this.addStdHeader("UTF-8");
    }

    @Override
    public void addRawString(String html) {
        super.addRawString(html);
    }

    public void addRawNewLine() {
        this.addRawString(StringUtils.CR);
    }

    public void insertJavaScript(String javaScript) {
        this.openElement(EHTMLElement.SCRIPT, new Object[]{EHTMLAttribute.TYPE, "text/javascript"});
        this.addRawNewLine();
        this.addRawString(javaScript);
        this.addRawNewLine();
        this.closeElement(EHTMLElement.SCRIPT);
    }

    public void addNonBreakingSpace() {
        this.addRawString("&nbsp;");
    }

    @Override
    public void addAttribute(EHTMLAttribute attribute, Object value) {
        if (!((EHTMLElement)((Object)this.getCurrentElement())).allowsAttribute(attribute)) {
            throw new HTMLWriterException("Attribute " + (Object)((Object)attribute) + " not allowed for element " + this.getCurrentElement());
        }
        if (!(attribute != EHTMLAttribute.STYLE && attribute != EHTMLAttribute.CLASS || value instanceof CSSDeclarationBlock)) {
            throw new HTMLWriterException("The argument for STYLE and CLASS attributes must be a " + CSSDeclarationBlock.class.getSimpleName() + "!");
        }
        if (attribute == EHTMLAttribute.STYLE) {
            super.addAttribute(attribute, ((CSSDeclarationBlock)value).toInlineStyle());
        } else if (attribute == EHTMLAttribute.CLASS) {
            super.addAttribute(attribute, this.cssManager.getCSSClassName((CSSDeclarationBlock)value));
        } else {
            super.addAttribute(attribute, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HTMLResolver
    implements IXMLResolver<EHTMLElement, EHTMLAttribute> {
        @Override
        public String resolveAttributeName(EHTMLAttribute attribute) {
            return attribute.toString();
        }

        @Override
        public String resolveElementName(EHTMLElement element) {
            return element.toString();
        }

        @Override
        public Class<EHTMLAttribute> getAttributeClass() {
            return EHTMLAttribute.class;
        }
    }
}

