/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Timer;
import java.util.TimerTask;
import org.conqat.lib.commons.concurrent.InterruptTimerTask;
import org.conqat.lib.commons.io.StreamReaderThread;

public class ProcessUtils {
    public static ExecutionResult execute(String[] completeArguments) throws IOException {
        return ProcessUtils.execute(completeArguments, null);
    }

    public static ExecutionResult execute(String[] completeArguments, String input) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(completeArguments);
        return ProcessUtils.execute(builder, input);
    }

    public static ExecutionResult execute(ProcessBuilder builder) throws IOException {
        return ProcessUtils.execute(builder, null);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input) throws IOException {
        return ProcessUtils.execute(builder, input, -1);
    }

    public static ExecutionResult execute(ProcessBuilder builder, String input, int timeOut) throws IOException {
        Process process = builder.start();
        StreamReaderThread stderrReader = new StreamReaderThread(process.getErrorStream());
        StreamReaderThread stdoutReader = new StreamReaderThread(process.getInputStream());
        if (input != null) {
            OutputStreamWriter stdIn = new OutputStreamWriter(process.getOutputStream());
            stdIn.write(input);
            ((Writer)stdIn).close();
        }
        boolean normalTermination = ProcessUtils.waitForProcess(process, timeOut);
        int exitValue = -1;
        if (normalTermination) {
            exitValue = process.exitValue();
        }
        try {
            stderrReader.join();
            stdoutReader.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return new ExecutionResult(stdoutReader.getContent(), stderrReader.getContent(), exitValue, normalTermination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForProcess(Process process, int maxRuntimeSeconds) {
        Timer timer = new Timer(true);
        if (maxRuntimeSeconds > 0) {
            timer.schedule((TimerTask)new InterruptTimerTask(Thread.currentThread()), maxRuntimeSeconds * 1000);
        }
        try {
            process.waitFor();
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            process.destroy();
            boolean bl = false;
            return bl;
        }
        finally {
            timer.cancel();
            Thread.interrupted();
        }
    }

    public static class ExecutionResult {
        private final String stdout;
        private final String stderr;
        private final int returnCode;
        private final boolean normalTermination;

        private ExecutionResult(String stdout, String stderr, int returnCode, boolean normalTermination) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.returnCode = returnCode;
            this.normalTermination = normalTermination;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public int getReturnCode() {
            return this.returnCode;
        }

        public boolean isNormalTermination() {
            return this.normalTermination;
        }
    }
}

