/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.conqat.lib.commons.logging.ILogger;
import org.conqat.lib.commons.string.StringUtils;

public class SimpleLogger
implements ILogger {
    private final PrintWriter writer;

    public SimpleLogger() {
        this(System.out);
    }

    public SimpleLogger(OutputStream stream) {
        this.writer = new PrintWriter(stream, true);
    }

    public SimpleLogger(PrintWriter writer) {
        this.writer = writer;
    }

    public void debug(Object message) {
        this.writer.println("DEBUG: " + message);
    }

    public void debug(Object message, Throwable throwable) {
        this.debug(message + ": " + StringUtils.obtainStackTrace(throwable));
    }

    public void error(Object message) {
        this.writer.println("ERROR: " + message);
    }

    public void error(Object message, Throwable throwable) {
        this.error(message + ": " + StringUtils.obtainStackTrace(throwable));
    }

    public void info(Object message) {
        this.writer.println("INFO : " + message);
    }

    public void info(Object message, Throwable throwable) {
        this.info(message + ": " + StringUtils.obtainStackTrace(throwable));
    }

    public void warn(Object message) {
        this.writer.println("WARN : " + message);
    }

    public void warn(Object message, Throwable throwable) {
        this.warn(message + ": " + StringUtils.obtainStackTrace(throwable));
    }
}

