/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import org.conqat.lib.commons.math.IAggregator;
import org.conqat.lib.commons.math.MaxAggregator;
import org.conqat.lib.commons.math.MeanAggregator;
import org.conqat.lib.commons.math.MinAggregator;
import org.conqat.lib.commons.math.PercentileAggregator;
import org.conqat.lib.commons.math.SumAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EAggregationStrategy {
    SUM(new SumAggregator()),
    MAX(new MaxAggregator()),
    MIN(new MinAggregator()),
    MEAN(new MeanAggregator()),
    MEDIAN(new PercentileAggregator(50.0)),
    PERCENTILE25(new PercentileAggregator(25.0)),
    PERCENTILE75(new PercentileAggregator(75.0));

    private final IAggregator aggregator;

    private EAggregationStrategy(IAggregator aggregator) {
        this.aggregator = aggregator;
    }

    public IAggregator getAggregator() {
        return this.aggregator;
    }
}

